/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.vmodel;

import ca.nanometrics.vmodel.StringModel;
import ca.nanometrics.vmodel.ValueListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;

public class StringModelTextField
extends JTextField
implements ValueListener {
    protected StringModel model;

    public StringModelTextField(StringModel amodel) {
        this.model = amodel;
        if (this.model == null) {
            throw new IllegalArgumentException("null model in StringModelTextField");
        }
        this.model.addValueListener(this);
        this.addKeyListener(new KeyMonitor());
        this.addFocusListener(new FocusMonitor());
    }

    public StringModelTextField(StringModel amodel, int columns) {
        this(amodel);
        this.setColumns(columns);
    }

    public void valueChanged(Object source) {
        super.setText(this.model.getValue());
    }

    public void setText(String text) {
        if (!this.model.setValue(text)) {
            this.valueChanged(this.model);
        }
    }

    public void update() {
        String text = this.getText();
        this.setText(text);
    }

    public void dispose() {
        this.model.removeValueListener(this);
    }

    class FocusMonitor
    implements FocusListener {
        FocusMonitor() {
        }

        public void focusLost(FocusEvent e) {
            StringModelTextField.this.update();
        }

        public void focusGained(FocusEvent e) {
        }
    }

    class KeyMonitor
    implements KeyListener {
        KeyMonitor() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                StringModelTextField.this.update();
            }
            if (e.getKeyCode() == 27) {
                StringModelTextField.this.valueChanged(StringModelTextField.this.model);
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }
    }
}

