/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.yfile;

import ca.nanometrics.yfile.YSection;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;

public class StnLocation
extends YSection {
    public static final int TAG_NUMBER = 2;
    public static final int FLAG_LENGTH = 8;
    public static final int DATA_LENGTH = 32;
    private byte[] updateFlags = new byte[8];
    private double latitude = 0.0;
    private double longitude = 0.0;
    private double elevation = 0.0;
    private double depth = 0.0;
    private double azimuth = 0.0;
    private double dip = 0.0;

    public StnLocation() {
        super(2, 32);
    }

    public StnLocation(DataInput input) throws IOException {
        this();
        this.readFrom(input);
    }

    public void readFrom(DataInput input) throws IOException {
        input.readFully(this.updateFlags);
        this.latitude = input.readFloat();
        this.longitude = input.readFloat();
        this.elevation = input.readFloat();
        this.depth = input.readFloat();
        this.azimuth = input.readFloat();
        this.dip = input.readFloat();
    }

    public void writeTo(DataOutput output) throws IOException {
        output.write(this.updateFlags);
        output.writeFloat((float)this.latitude);
        output.writeFloat((float)this.longitude);
        output.writeFloat((float)this.elevation);
        output.writeFloat((float)this.depth);
        output.writeFloat((float)this.azimuth);
        output.writeFloat((float)this.dip);
    }

    public void display(PrintStream out) {
        out.println("Station Location:");
        out.println("  Latitude  = " + this.getLatitude());
        out.println("  Longitude = " + this.getLongitude());
        out.println("  Elevation = " + this.getElevation());
        out.println("  Depth     = " + this.getDepth());
        out.println("  Azimuth   = " + this.getAzimuth());
        out.println("  Dip       = " + this.getDip());
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getElevation() {
        return this.elevation;
    }

    public double getDepth() {
        return this.depth;
    }

    public double getAzimuth() {
        return this.azimuth;
    }

    public double getDip() {
        return this.dip;
    }

    public void setLatitude(double degrees) {
        this.latitude = degrees;
    }

    public void setLongitude(double degrees) {
        this.longitude = degrees;
    }

    public void setElevation(double meters) {
        this.elevation = meters;
    }

    public void setDepth(double meters) {
        this.depth = meters;
    }

    public void setAzimuth(double degrees) {
        this.azimuth = degrees;
    }

    public void setDip(double degrees) {
        this.dip = degrees;
    }
}

