/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.acq.Watchdog;
import ca.nanometrics.naqs.stndb.SimpleStationDatabase;
import ca.nanometrics.naqs.stndb.StationDatabase;
import ca.nanometrics.net.MultiServer;
import ca.nanometrics.util.AppLog;
import ca.nanometrics.util.ConsoleMonitor;
import ca.nanometrics.util.FileLog;
import ca.nanometrics.util.Log;
import ca.nanometrics.util.LoopRunner;
import ca.nanometrics.util.StringQueue;
import java.io.FileNotFoundException;
import java.io.IOException;

public class DataServer
extends LoopRunner {
    static final String VERSION = "1.5.5";
    static final String INI_FILE = "DataServer.ini";
    static final String STNDB_FILE = "Naqs.stn";
    private Watchdog m_watchdog;
    private DataServerConfig m_config;
    private AppLog m_appLog;
    private MultiServer m_server;
    private StationDatabase m_stndb;
    private RbfDataServerFactory m_factory;
    private StringQueue m_console;

    public DataServer(String[] args) throws IOException {
        try {
            Log.installLog(new FileLog("DataServer.log"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.loadConfig(args);
        this.loadStndb(args);
        this.m_appLog = new AppLog(this.m_config.getLogConfig());
        Log.installLog(this.m_appLog);
        this.writeBanner();
        this.showParameters();
        this.m_watchdog = Watchdog.getWatchdog();
        if (this.m_watchdog.isOpen()) {
            Log.report(this, 13, 2, "Using software watchdog.");
        } else {
            Log.report(this, 12, 3, "Software watchdog not found.");
        }
        this.m_watchdog.startShutdownMonitor(this);
        this.m_console = ConsoleMonitor.getInputQueue();
        this.m_factory = new RbfDataServerFactory(this.m_stndb, this.m_config.getEventConfig(), this.m_config.getUsers());
        this.m_server = new MultiServer(this.m_config.getServerConfig(), this.m_factory);
    }

    private void loadConfig(String[] args) throws IOException {
        String iniFileName = INI_FILE;
        if (args.length > 0) {
            iniFileName = args[0];
        }
        try {
            Log.report(this, 1, 2, "Loading confguration from: " + iniFileName);
            this.m_config = new DataServerConfig(iniFileName);
        }
        catch (FileNotFoundException fnfe) {
            throw new IOException("DataServer ini file not found: " + iniFileName);
        }
        catch (Exception exc) {
            throw new IOException("Error loading config: " + exc.getMessage());
        }
    }

    private void loadStndb(String[] args) throws IOException {
        String stnSource = STNDB_FILE;
        if (args.length > 1) {
            stnSource = args[1];
        }
        try {
            Log.report(this, 2, 2, "loading station database from " + stnSource);
            this.m_stndb = new SimpleStationDatabase(stnSource);
        }
        catch (FileNotFoundException fnfe) {
            throw new IOException("Station database file not found: " + stnSource);
        }
        catch (Exception exc) {
            throw new IOException("Error loading station database: " + exc.getMessage());
        }
    }

    private void writeBanner() {
        Log.report(this, 0, 2, "*********************************************");
        Log.report(this, 0, 2, "* Nanometrics Data Access Server");
        Log.report(this, 0, 2, "* DataServer version 1.5.5");
        Log.report(this, 0, 2, "* copyright (C) Nanometrics, Inc. 2001-2002");
        Log.report(this, 0, 2, "---------------------------------------------");
    }

    private void showParameters() {
    }

    protected void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleConsole() {
        try {
            while (true) {
                if (this.m_console.size() <= 0) {
                    return true;
                }
                String input = this.m_console.get(200);
                if (input == null) continue;
                if (input.equalsIgnoreCase("QUIT")) {
                    Log.report(this, 5, 2, "User exit.");
                    return false;
                }
                if (input.equalsIgnoreCase("D")) {
                    this.m_appLog.setVerbosity(0);
                    continue;
                }
                if (input.equalsIgnoreCase("V")) {
                    this.m_appLog.setVerbosity(1);
                    continue;
                }
                if (input.equalsIgnoreCase("I")) {
                    this.m_appLog.setVerbosity(2);
                    continue;
                }
                if (input.equalsIgnoreCase("M")) {
                    this.m_appLog.move();
                    continue;
                }
                Log.report(this, 9, 3, "Invalid console input: " + input);
            }
        }
        catch (IOException e) {
            Log.report(this, 8, 4, "Error moving log file: " + e.getMessage());
            return true;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    private boolean isAllRunningOK() {
        boolean isMultiServerOK = this.m_server.isRunningOk();
        if (!isMultiServerOK) {
            Log.report(this, 9, 4, "MultiServer is not Running Ok");
        }
        return isMultiServerOK;
    }

    protected void body() {
        if (this.m_appLog.reopenOnNewDate()) {
            Log.report(this, 0, 2, "DataServer version 1.5.5");
        }
        this.stayAlive &= this.handleConsole();
        this.sleep(200);
    }

    protected void tick() {
        if (this.isAllRunningOK()) {
            this.m_watchdog.hitWatchdog();
        } else {
            Log.report(this, 4, 5, "Thread died ... quitting ...");
            this.stayAlive = false;
        }
    }

    protected void open() {
        this.m_server.start();
        this.sleep(1000);
        Log.report(this, 10, 2, "DataServer started successfully");
    }

    protected void close() {
        this.m_server.stop();
        Log.report(this, 3, 2, "DataServer stopped.");
    }

    public static void main(String[] args) {
        DataServer instance = null;
        try {
            instance = new DataServer(args);
        }
        catch (Exception exc) {
            Log.report("DataServer", 10, 5, "Cannot create DataServer: " + exc);
            System.exit(1);
        }
        instance.start();
        try {
            instance.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }
}

