/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.net.MultiServerConfig;
import ca.nanometrics.util.AppLogConfig;
import ca.nanometrics.util.LogConfig;
import ca.nanometrics.util.SimpleParser;
import java.io.IOException;
import java.util.Properties;

public class DataServerConfig {
    private LogConfig logConfig;
    private MultiServerConfig serverConfig;
    private EventSourceConfig eventConfig;
    private Properties users = new Properties();

    public DataServerConfig(String filename) throws IOException {
        SimpleParser parser = new SimpleParser(filename);
        parser.getHeader("Log");
        this.logConfig = new AppLogConfig(parser.readString("LogFilename"), parser.readString("LogDirectory"), parser.readString("Verbosity"));
        parser.getHeader("TcpServer");
        this.serverConfig = new MultiServerConfig(parser.readInt("Port"), parser.readInt("MaxConnections"), false);
        parser.getHeader("EventData");
        this.eventConfig = new EventSourceConfig(parser.readString("Directory"), parser.readString("Filename"));
        parser.getHeader("Users");
        while (parser.isNextLineParam()) {
            String username = parser.peekLabel();
            String password = parser.readString(username);
            this.users.put(username, password);
        }
    }

    public LogConfig getLogConfig() {
        return this.logConfig;
    }

    public MultiServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public EventSourceConfig getEventConfig() {
        return this.eventConfig;
    }

    public Properties getUsers() {
        return this.users;
    }
}

