/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.util.NmxDateFormat;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;

public class DatedFileBuilder {
    private String parent;
    private String baseName;
    private String extension;
    private NmxDateFormat dateFormat = new NmxDateFormat("yyyyMMdd");

    public DatedFileBuilder(String parentName, String fileName) {
        this.parent = parentName;
        this.baseName = fileName;
        this.extension = "";
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot >= 0) {
            this.baseName = String.valueOf(fileName.substring(0, lastDot)) + "_";
            this.extension = fileName.substring(lastDot);
        }
    }

    public String getParent() {
        return this.parent;
    }

    public String getName(double timeSec) {
        String filename = String.valueOf(this.baseName) + this.dateFormat.format(timeSec) + this.extension;
        return filename;
    }

    public File[] listFiles(int startSec, int endSec) {
        File file = new File(this.parent);
        Object[] list = file.listFiles(new LocalFilter(startSec, endSec));
        if (list == null) {
            list = new File[]{};
        }
        Arrays.sort(list);
        return list;
    }

    public File[] listFiles() {
        return this.listFiles(0, Integer.MAX_VALUE);
    }

    public static void main(String[] args) {
        DatedFileBuilder dfb = new DatedFileBuilder("data", "Naqs.elf");
        File[] list = dfb.listFiles(989500000, 999500000);
        int ix = 0;
        while (ix < list.length) {
            System.out.println("File " + ix + " is " + list[ix]);
            ++ix;
        }
    }

    private class LocalFilter
    implements FileFilter {
        String firstName;
        String lastName;

        public LocalFilter(int startSec, int endSec) {
            this.firstName = DatedFileBuilder.this.getName(startSec);
            this.lastName = DatedFileBuilder.this.getName(endSec);
        }

        public boolean accept(File file) {
            String name = file.getName();
            String dir = file.getParent();
            return DatedFileBuilder.this.parent.equals(dir) && name.startsWith(DatedFileBuilder.this.baseName) && name.endsWith(DatedFileBuilder.this.extension) && name.compareTo(this.firstName) >= 0 && name.compareTo(this.lastName) <= 0;
        }
    }
}

