/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.nda.NaqsEvent;
import ca.nanometrics.nda.NaqsTrigger;
import ca.nanometrics.util.NmxDateFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.StringTokenizer;

public class EventFileReader {
    private File elf;
    private BufferedReader input = null;
    private NmxDateFormat eventDateFormat = new NmxDateFormat("MMM-d-HH:mm:ss-yyyy");
    private NmxDateFormat trigDateFormat = new NmxDateFormat("yyyy-MM-dd-HH:mm:ss.SSS");

    public EventFileReader(File file) {
        this.elf = file;
    }

    public EventFileReader(String filename) {
        this.elf = new File(filename);
    }

    public EventFileReader(String path, String filename) {
        this.elf = new File(path, filename);
    }

    private NaqsEvent parseEvent(String line) {
        StringTokenizer stkn;
        block3: {
            try {
                stkn = new StringTokenizer(line);
                String type = stkn.nextToken();
                if (type.equalsIgnoreCase("e")) break block3;
                return null;
            }
            catch (Exception any) {
                return null;
            }
        }
        stkn.nextToken();
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(stkn.nextToken()) + "-");
        sb.append(String.valueOf(stkn.nextToken()) + "-");
        sb.append(String.valueOf(stkn.nextToken()) + "-");
        sb.append(stkn.nextToken());
        String dateString = sb.toString();
        long time = this.eventDateFormat.parse(dateString).getTime();
        String stationName = stkn.nextToken();
        int duration = Integer.parseInt(stkn.nextToken());
        return new NaqsEvent(0.001 * (double)time, (double)duration, 1.0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NaqsEvent nextEvent() {
        try {
            String line;
            NaqsEvent event;
            if (this.input == null) {
                this.input = new BufferedReader(new FileReader(this.elf));
            }
            do {
                if ((line = this.input.readLine()) != null) continue;
                return null;
            } while ((event = this.parseEvent(line)) == null);
            return event;
        }
        catch (Exception any) {
            return null;
        }
    }

    private NaqsTrigger parseTrigger(String line) {
        StringTokenizer stkn;
        block4: {
            try {
                stkn = new StringTokenizer(line);
                String type = stkn.nextToken();
                if (type.equalsIgnoreCase("t")) break block4;
                return null;
            }
            catch (Exception any) {
                return null;
            }
        }
        String dateString = stkn.nextToken();
        long time = this.trigDateFormat.parse(dateString).getTime();
        String channelName = stkn.nextToken();
        int dashPos = channelName.indexOf(45);
        if (dashPos > 0) {
            channelName = channelName.substring(0, dashPos);
        }
        int duration = Integer.parseInt(stkn.nextToken());
        return new NaqsTrigger(1, channelName, 0.001 * (double)time, duration);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NaqsTrigger nextTrigger() {
        try {
            String line;
            NaqsTrigger trigger;
            if (this.input == null) {
                this.input = new BufferedReader(new FileReader(this.elf));
            }
            do {
                if ((line = this.input.readLine()) != null) continue;
                return null;
            } while ((trigger = this.parseTrigger(line)) == null);
            return trigger;
        }
        catch (Exception any) {
            return null;
        }
    }

    public void close() {
        try {
            if (this.input != null) {
                this.input.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.input = null;
    }
}

