/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.acq.RbfWrapper;
import ca.nanometrics.msg.ChannelList;
import ca.nanometrics.msg.RequestPending;
import ca.nanometrics.msg.TerminateMessage;
import ca.nanometrics.naqs.stndb.ChannelConfig;
import ca.nanometrics.naqs.stndb.StationDatabase;
import ca.nanometrics.nda.CancelRequest;
import ca.nanometrics.nda.ChannelHeader;
import ca.nanometrics.nda.ChannelInfoRequest;
import ca.nanometrics.nda.ChannelListRequest;
import ca.nanometrics.nda.ConnectRequest;
import ca.nanometrics.nda.ConnectResponse;
import ca.nanometrics.nda.DataRequest;
import ca.nanometrics.nda.DataSize;
import ca.nanometrics.nda.DataSizeRequest;
import ca.nanometrics.nda.EventRequest;
import ca.nanometrics.nda.NaqsEvent;
import ca.nanometrics.nda.NaqsTrigger;
import ca.nanometrics.nda.NdaMessageDecoder;
import ca.nanometrics.nda.PrecisList;
import ca.nanometrics.nda.PrecisListRequest;
import ca.nanometrics.nda.ReadyMessage;
import ca.nanometrics.nda.ResponseFileMsg;
import ca.nanometrics.nda.SohRequest;
import ca.nanometrics.nda.TcpMsgLink;
import ca.nanometrics.nda.TimeSeriesRequest;
import ca.nanometrics.nda.TriggerRequest;
import ca.nanometrics.nda.Y5HeaderMsg;
import ca.nanometrics.net.ConnectionHandler;
import ca.nanometrics.packet.ChannelKey;
import ca.nanometrics.packet.NmxPacket;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.Log;
import ca.nanometrics.util.Runner;
import ca.nanometrics.yfile.DataTag;
import ca.nanometrics.yfile.Y5Header;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.util.Iterator;
import java.util.Properties;

public class RbfDataServer
extends Runner
implements ConnectionHandler {
    public static final int CANCEL_INTERVAL = 100;
    public static final int MAX_RESPONSE_FILE = 64000;
    private StationDatabase stndb;
    private ChannelConfigTable channels = new ChannelConfigTable();
    private TcpMsgLink connection;
    private DatedFileBuilder eventFileSource;
    private int readTimeout = 1000;
    private int writeTimeout = 10000;
    private int requestTimeout = 20000;
    private String name;
    private int port;
    private Properties usernames;
    private boolean isConnected = false;

    public RbfDataServer(Socket socket, StationDatabase stnDatabase, DatedFileBuilder eventFileBuilder, Properties userlist) throws IOException {
        this.stndb = stnDatabase;
        this.connection = new TcpMsgLink(socket, new NdaMessageDecoder(), this.writeTimeout, 2);
        this.connection.setReadTimeout(this.readTimeout);
        this.name = this.connection.toString();
        this.port = socket.getPort();
        this.usernames = userlist;
        this.eventFileSource = eventFileBuilder;
        Iterator iter = this.stndb.getChannels().iterator();
        while (iter.hasNext()) {
            this.channels.put((ChannelConfig)iter.next());
        }
    }

    public String connectionName() {
        return this.name;
    }

    private boolean isPacketAvailable() throws IOException {
        return this.connection.isPacketAvailable();
    }

    protected void handleConnectRequest(ConnectRequest request) throws IOException {
        String passwd;
        String username = request.getUsername();
        boolean wasConnected = this.isConnected;
        if (!this.isConnected) {
            passwd = this.usernames.getProperty("any");
            boolean bl = this.isConnected = passwd != null && passwd.equalsIgnoreCase("none");
        }
        if (!this.isConnected) {
            passwd = this.usernames.getProperty(username);
            boolean bl = this.isConnected = passwd != null && request.isValid(passwd, 1800);
        }
        if (this.isConnected) {
            this.connection.write(new ConnectResponse(request.getProtocolVersion()));
            if (!wasConnected) {
                Log.report(this, 31, 1, "User " + username + " logged on from " + this.connection);
            }
        } else {
            this.terminate(2, "invalid logon");
            Log.report(this, 32, 1, "Invalid logon from " + username);
        }
    }

    protected void handleRequestPending(RequestPending request) throws IOException {
    }

    protected void handleCancelRequest(CancelRequest request) throws IOException {
    }

    protected void handleTerminateMessage(TerminateMessage request) {
        this.stayAlive = false;
    }

    protected void handleTimeSeriesRequest(TimeSeriesRequest request) throws IOException {
    }

    protected void handleTriggerRequest(TriggerRequest request) throws IOException {
        ChannelList list = this.stndb.getChannelList();
        int startSec = request.getStartTime();
        int endSec = request.getEndTime();
        int keySpec = request.getKey();
        File[] files = this.eventFileSource.listFiles(startSec, endSec);
        int ix = 0;
        while (ix < files.length) {
            NaqsTrigger trigger;
            EventFileReader efr = new EventFileReader(files[ix]);
            while ((trigger = efr.nextTrigger()) != null) {
                String name;
                int key;
                double trigTime = trigger.getTriggerTime();
                if (!(trigTime >= (double)startSec) || !(trigTime <= (double)endSec) || (key = list.getKeyOf(name = trigger.getName())) == -1 || key != keySpec && keySpec != 0) continue;
                this.connection.write(new NaqsTrigger(key, name, trigTime, trigger.getDuration()));
            }
            ++ix;
        }
    }

    protected void handleEventRequest(EventRequest request) throws IOException {
        int startSec = request.getStartTime();
        int endSec = request.getEndTime();
        double threshold = request.getAmplitude();
        File[] files = this.eventFileSource.listFiles(startSec, endSec);
        int ix = 0;
        while (ix < files.length) {
            NaqsEvent event;
            EventFileReader efr = new EventFileReader(files[ix]);
            while ((event = efr.nextEvent()) != null) {
                double eventTime = event.getEventTime();
                double amplitude = event.getAmplitude();
                if (!(eventTime >= (double)startSec) || !(eventTime <= (double)endSec) || !(amplitude >= threshold)) continue;
                this.connection.write(event);
            }
            ++ix;
        }
    }

    private int lookupFileTag(int key) {
        int type = ChannelKey.getTypeOf(key);
        if (type == 6) {
            return 45;
        }
        if (type == 2) {
            return 44;
        }
        return 43;
    }

    private RbfWrapper openRingBuffer(int key) {
        ChannelConfig cfg = this.channels.get(new Integer(key));
        int tag = this.lookupFileTag(key);
        if (cfg != null) {
            RbfWrapper rbf = new RbfWrapper();
            String rbfName = cfg.getChannelPathName();
            if (rbf.openRingBuffer(rbfName, tag) == 0) {
                return rbf;
            }
            Log.report(this, 3, 0, "Can't open RBF File " + rbfName);
            rbf.closeRingBuffer();
        }
        return null;
    }

    protected void handleChannelListRequest(ChannelListRequest request) throws IOException {
        this.connection.write(this.stndb.getChannelList());
    }

    protected void handlePrecisListRequest(PrecisListRequest request) throws IOException {
        int[] keys = this.channels.getAllKeys();
        keys = request.getMatchingKeys(keys);
        int keyCount = keys.length;
        PrecisList list = new PrecisList();
        int ix = 0;
        while (ix < keyCount) {
            int key = keys[ix];
            String channelName = this.channels.getNameOf(key);
            RbfWrapper rbf = this.openRingBuffer(key);
            if (rbf != null) {
                int rbfStart = (int)rbf.getStartTime();
                int rbfEnd = (int)rbf.getEndTime();
                rbf.closeRingBuffer();
                list.add(key, channelName, rbfStart, rbfEnd);
            }
            ++ix;
        }
        this.connection.write(list);
    }

    protected byte[] readFileToBytes(String respFile, int maxLength) {
        File file = new File(respFile);
        DataInputStream dis = null;
        try {
            dis = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            int bytesToRead = Math.min((int)file.length(), maxLength);
            byte[] buffer = new byte[bytesToRead];
            dis.readFully(buffer);
            dis.close();
            return buffer;
        }
        catch (IOException ioe) {
            Log.report(this, 3, 0, "exception reading " + respFile + ": " + ioe.toString());
            try {
                dis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    protected void handleResponseRequest(int key) throws IOException {
        ChannelConfig cfg = this.channels.get(new Integer(key));
        if (cfg != null) {
            String respFile = cfg.getResponseFile();
            if (respFile.equals("none")) {
                Log.report(this, 3, 0, "Channel data unavailable for " + cfg.getDottedName());
            } else {
                byte[] respData = this.readFileToBytes(respFile, 64000);
                if (respData != null) {
                    this.connection.write(new ResponseFileMsg(key, respData));
                } else {
                    Log.report(this, 3, 0, "Can't read response data from " + respFile);
                }
            }
        }
    }

    protected Y5Header getY5Header(String rbfName) {
        DataInputStream dis = null;
        try {
            Y5Header yflhdr = null;
            dis = new DataInputStream(new BufferedInputStream(new FileInputStream(rbfName)));
            DataTag fileTag = new DataTag(dis);
            int fileType = fileTag.getType();
            if (fileType == 43 || fileType == 44 || fileType == 45) {
                yflhdr = new Y5Header();
                yflhdr.readHeader(dis);
            } else {
                Log.report(this, 3, 0, String.valueOf(rbfName) + " is not a valid rbf type");
            }
            dis.close();
            return yflhdr;
        }
        catch (IOException ioe) {
            Log.report(this, 3, 0, "Error reading Y5Header from " + rbfName + ": " + ioe);
            try {
                dis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    protected void handleY5HeaderRequest(int key) throws IOException {
        ChannelConfig cfg = this.channels.get(new Integer(key));
        if (cfg != null) {
            String rbfName = cfg.getChannelPathName();
            Y5Header yflhdr = this.getY5Header(rbfName);
            if (yflhdr != null) {
                this.connection.write(new Y5HeaderMsg(key, yflhdr));
            } else {
                Log.report(this, 3, 0, "Can't read Y5Header from " + rbfName);
            }
        }
    }

    protected void handleHeaderRequest(int key) throws IOException {
        RbfWrapper rbf;
        String channelName = this.channels.getNameOf(key);
        String network = this.stndb.getNetworkTag();
        if (channelName != null && (rbf = this.openRingBuffer(key)) != null) {
            rbf.closeRingBuffer();
            this.connection.write(new ChannelHeader(key, channelName, network));
        }
    }

    protected void handleInfoRequest(ChannelInfoRequest request) throws IOException {
        int key = request.getKey();
        int requestType = request.getType();
        if (requestType == 0) {
            this.handleHeaderRequest(key);
        } else if (requestType == 1) {
            this.handleY5HeaderRequest(key);
        } else if (requestType == 2) {
            this.handleResponseRequest(key);
        }
    }

    private int getPacketCount(RbfWrapper rbf, int startTime, int endTime) {
        int numEntry = 0;
        int maxEntry = rbf.getMaxEntry();
        byte[] firstPkt = rbf.extractFirstPacket(startTime, endTime);
        if (firstPkt != null) {
            int firstEntry = rbf.getLastExtracted();
            int lastEntry = rbf.getNewestEntry();
            byte[] lastPkt = rbf.extractNextPacket(endTime, endTime);
            if (lastPkt != null) {
                lastEntry = rbf.getLastExtracted();
            }
            numEntry = 1 + (lastEntry + maxEntry - firstEntry) % maxEntry;
        }
        return numEntry;
    }

    private void sendChannelData(RbfWrapper rbf, long startSec, long endSec) throws IOException {
        int packetsSent = 0;
        boolean cancelled = false;
        byte[] pktBytes = rbf.extractFirstPacket(startSec, endSec);
        while (pktBytes != null && !cancelled) {
            NmxPacket nmxPacket = new NmxPacket(pktBytes, 0);
            this.connection.write(nmxPacket);
            if (++packetsSent % 100 == 0) {
                cancelled = this.isPacketAvailable();
            }
            pktBytes = rbf.extractNextPacket(startSec, endSec);
        }
        Log.report(this, 5, 1, String.valueOf(this.name) + " Sent " + packetsSent + " packets");
    }

    protected void handleDataRequest(DataRequest request) throws IOException {
        int key = request.getKey();
        int startTime = request.getStartTime();
        int endTime = request.getEndTime();
        RbfWrapper rbf = this.openRingBuffer(key);
        if (rbf != null) {
            try {
                this.sendChannelData(rbf, startTime, endTime);
            }
            finally {
                rbf.closeRingBuffer();
            }
        }
    }

    protected void handleSohRequest(SohRequest request) throws IOException {
        int key = request.getKey();
        int startTime = request.getStartTime();
        int endTime = request.getEndTime();
        RbfWrapper rbf = this.openRingBuffer(key);
        if (rbf != null) {
            try {
                this.sendChannelData(rbf, startTime, endTime);
            }
            finally {
                rbf.closeRingBuffer();
            }
        }
    }

    protected void handleDataSizeRequest(DataSizeRequest request) throws IOException {
        int key = request.getKey();
        int startTime = request.getStartTime();
        int endTime = request.getEndTime();
        RbfWrapper rbf = this.openRingBuffer(key);
        if (rbf != null) {
            int packetLength = rbf.getPacketSize();
            int numEntry = this.getPacketCount(rbf, startTime, endTime);
            rbf.closeRingBuffer();
            this.connection.write(new DataSize(key, packetLength, numEntry));
        }
    }

    protected void handleUnknownRequest(Packable request) throws IOException {
        Log.report(this, 3, 1, String.valueOf(this.name) + " unknown request " + request);
        this.terminate(2, "Unknown message type " + request.getDataType());
    }

    protected void handleRequest(Packable request) throws IOException {
        Log.report(this, 3, 0, String.valueOf(this.name) + " Rx " + request);
        if (request instanceof ConnectRequest) {
            this.handleConnectRequest((ConnectRequest)request);
        } else if (!this.isConnected) {
            this.terminate(2, "not logged on");
        } else if (request instanceof TerminateMessage) {
            this.handleTerminateMessage((TerminateMessage)request);
        } else if (request instanceof RequestPending) {
            this.handleRequestPending((RequestPending)request);
        } else if (request instanceof CancelRequest) {
            this.handleCancelRequest((CancelRequest)request);
        } else if (request instanceof ChannelListRequest) {
            this.handleChannelListRequest((ChannelListRequest)request);
        } else if (request instanceof PrecisListRequest) {
            this.handlePrecisListRequest((PrecisListRequest)request);
        } else if (request instanceof ChannelInfoRequest) {
            this.handleInfoRequest((ChannelInfoRequest)request);
        } else if (request instanceof DataRequest) {
            this.handleDataRequest((DataRequest)request);
        } else if (request instanceof SohRequest) {
            this.handleSohRequest((SohRequest)request);
        } else if (request instanceof TimeSeriesRequest) {
            this.handleTimeSeriesRequest((TimeSeriesRequest)request);
        } else if (request instanceof TriggerRequest) {
            this.handleTriggerRequest((TriggerRequest)request);
        } else if (request instanceof EventRequest) {
            this.handleEventRequest((EventRequest)request);
        } else if (request instanceof DataSizeRequest) {
            this.handleDataSizeRequest((DataSizeRequest)request);
        } else {
            this.handleUnknownRequest(request);
        }
        this.connection.write(new ReadyMessage());
        this.connection.flush();
    }

    protected void terminate(int type, String msg) {
        this.stayAlive = false;
        this.connection.send(new TerminateMessage(2, msg));
    }

    public void run() {
        int ticksSinceLastResponse = 0;
        int ticksUntilTimeout = this.requestTimeout / this.readTimeout;
        while (this.stayAlive && ticksSinceLastResponse < ticksUntilTimeout) {
            try {
                Packable request = this.connection.read();
                this.handleRequest(request);
                ticksSinceLastResponse = 0;
            }
            catch (InterruptedIOException iioe) {
                if (++ticksSinceLastResponse < ticksUntilTimeout) continue;
                Log.report(this, 3, 0, String.valueOf(this.name) + " timed out");
                this.terminate(3, "connection timed out.");
            }
            catch (IOException ioe) {
                Log.report(this, 1, 3, "Exception on " + this.name + ": " + ioe);
                Log.report(this, 2, 3, "Closing connection " + this.name);
                this.stayAlive = false;
            }
            catch (Exception any) {
                Log.report(this, 1, 3, "Exception on " + this.name + ": " + any);
                Log.report(this, 2, 3, "Closing connection " + this.name);
                any.printStackTrace();
                this.stayAlive = false;
            }
        }
        Log.report(this, 1, 1, String.valueOf(this.name) + " closing");
        this.connection.close();
    }
}

