/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.msg.ChannelList;
import ca.nanometrics.nda.ChannelHeader;
import ca.nanometrics.nda.ChannelPrecis;
import ca.nanometrics.nda.DataSize;
import ca.nanometrics.nda.NmxDataSource;
import ca.nanometrics.nda.PacketConsumer;
import ca.nanometrics.nda.PrecisList;
import ca.nanometrics.nda.TcpDataSource;
import ca.nanometrics.packet.ChannelKey;
import ca.nanometrics.packet.Instrument;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.ConsoleMonitor;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.NmxDateFormat;
import ca.nanometrics.util.StringQueue;
import ca.nanometrics.yfile.Y5Header;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.StringTokenizer;

public class TestDataSource {
    private NmxDataSource ds;
    private NmxDateFormat dateFmt = new NmxDateFormat();
    private TrivialPacketConsumer handler;
    private ChannelList channelList = null;
    private PrecisList precisList = null;
    private boolean stayAlive = true;
    private StringQueue console = ConsoleMonitor.getInputQueue();
    private int currentChannel = 0;

    public TestDataSource(String name, String password, String host, int port) {
        this.ds = new TcpDataSource(host, port, name, password);
        this.handler = new TrivialPacketConsumer();
    }

    protected String[] makeArgs(String input) {
        if (input == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(input);
        int argc = st.countTokens();
        String[] args = new String[argc];
        int ix = 0;
        while (ix < argc) {
            args[ix] = st.nextToken();
            ++ix;
        }
        return args;
    }

    protected void assertChannelListExists() throws IOException {
        if (this.channelList == null) {
            this.channelList = this.ds.getChannelList();
        }
        if (this.channelList == null) {
            throw new IOException("cannot obtain channel list");
        }
    }

    protected void assertPrecisListExists() throws IOException {
        if (this.precisList == null) {
            this.precisList = this.ds.getPrecisList();
        }
        if (this.precisList == null) {
            throw new IOException("cannot obtain precis list");
        }
    }

    protected void getChannelList() throws IOException {
        System.out.println("getting channel list");
        this.channelList = this.ds.getChannelList();
        if (this.channelList == null) {
            System.out.println("channelList is empty");
        } else {
            this.displayChannelList();
        }
    }

    protected void displayChannelList() throws IOException {
        this.assertChannelListExists();
        System.out.println("channel list contains:");
        Iterator iter = this.channelList.names();
        while (iter.hasNext()) {
            String channelName = (String)iter.next();
            System.out.println(String.valueOf(channelName) + " " + this.channelList.getKeyOf(channelName));
        }
    }

    protected void getPrecisList(String[] args) throws IOException {
        System.out.println("getting precis list");
        this.precisList = args.length > 3 ? this.ds.getPrecisList(Integer.parseInt(args[1]), Integer.parseInt(args[2]), Integer.parseInt(args[3])) : (args.length > 1 ? this.ds.getPrecisList(Integer.parseInt(args[1])) : this.ds.getPrecisList());
        if (this.precisList == null) {
            System.out.println("precisList is empty");
        } else {
            this.displayPrecisList();
        }
    }

    protected void displayPrecisList() throws IOException {
        this.assertPrecisListExists();
        Format fmt = new Format("%10d");
        System.out.println("precis list contains:");
        Iterator iter = this.precisList.iterator();
        while (iter.hasNext()) {
            ChannelPrecis cp = (ChannelPrecis)iter.next();
            int key = cp.getKey();
            int id = ChannelKey.getIDOf(key);
            String instrument = Instrument.getNameOf(id);
            System.out.println(String.valueOf(cp.getName()) + " " + instrument + " " + fmt.form(key) + " " + fmt.form(cp.getStartTime()) + " " + fmt.form(cp.getEndTime()));
        }
    }

    protected int getChannelKey(String name) throws IOException {
        this.assertChannelListExists();
        return this.channelList.getKeyOf(name.toUpperCase());
    }

    protected void getChannelHeader(String[] args) throws IOException {
        if (args.length > 1) {
            String channelName = args[1];
            int key = this.getChannelKey(channelName);
            if (key == -1) {
                System.out.println("channel not found: " + channelName);
                return;
            }
            System.out.println("getting header for " + channelName);
            ChannelHeader ch = this.ds.getChannelHeader(key);
            if (ch == null) {
                System.out.println("channel header not found");
            } else {
                System.out.println("channel header is " + ch + " " + ch.getNetwork());
            }
        } else {
            System.out.println("usage:  ch channelName");
        }
    }

    protected void getY5Header(String[] args) throws IOException {
        if (args.length > 1) {
            String channelName = args[1];
            int key = this.getChannelKey(channelName);
            if (key == -1) {
                System.out.println("channel not found: " + channelName);
                return;
            }
            System.out.println("getting Y5 header for " + channelName);
            Y5Header yfl = this.ds.getY5Header(key);
            if (yfl == null) {
                System.out.println("Y5 header not found");
            } else {
                yfl.display(System.out);
            }
        } else {
            System.out.println("usage:  yf channelName");
        }
    }

    protected void getY5File(String[] args) throws IOException {
        if (args.length > 3) {
            String channelName = args[1];
            int key = this.getChannelKey(channelName);
            if (key == -1) {
                System.out.println("channel not found: " + channelName);
                return;
            }
            System.out.println("getting Y5 header for " + channelName);
            Y5Header yfl = this.ds.getY5Header(key);
            if (yfl == null) {
                System.out.println("Y5 header not found");
                return;
            }
            int startSec = (int)(NmxDateFormat.parseDate(args[2]).getTime() / 1000L);
            int duration = Integer.parseInt(args[3]);
            int endSec = startSec + duration;
            YFileBuilder yflBuilder = new YFileBuilder(yfl, startSec, endSec);
            System.out.println("getting data for " + channelName + " for " + duration + " seconds starting at " + startSec);
            this.ds.getData(key, startSec, endSec, yflBuilder);
            yflBuilder.flush();
        } else {
            System.out.println("usage:  yfile channelName startTime duration");
        }
    }

    protected void getResponseFile(String[] args) throws IOException {
        if (args.length > 1) {
            String channelName = args[1];
            int key = this.getChannelKey(channelName);
            if (key == -1) {
                System.out.println("channel not found: " + channelName);
                return;
            }
            System.out.println("getting response file for " + channelName);
            InputStream input = this.ds.getResponseFile(key);
            if (input == null) {
                System.out.println("response file not found");
            } else {
                try {
                    byte[] buffer = new byte[256];
                    while (input.available() > 0) {
                        int numread = input.read(buffer);
                        System.out.write(buffer, 0, numread);
                    }
                }
                catch (Exception any) {
                    any.printStackTrace();
                }
            }
        } else {
            System.out.println("usage:  rf channelName");
        }
    }

    protected void getDataSize(String[] args) throws IOException {
        if (args.length > 3) {
            String channelName = args[1];
            int key = this.getChannelKey(channelName);
            if (key == -1) {
                System.out.println("channel not found: " + channelName);
                return;
            }
            int startSec = Integer.parseInt(args[2]);
            int duration = Integer.parseInt(args[3]);
            int endSec = startSec + duration;
            System.out.println("getting data size for " + channelName + " for " + duration + " seconds starting at " + startSec);
            DataSize size = this.ds.getDataSize(key, startSec, endSec);
            if (size == null) {
                System.out.println("data size not found");
            } else {
                System.out.println("packet length is " + size.getPacketLength() + ", packet count is " + size.getMaxPacketCount());
            }
        } else {
            System.out.println("usage:  ds channelName startSec duration");
        }
    }

    protected void getData(String[] args) throws IOException {
        if (args.length > 3) {
            String channelName = args[1];
            int key = this.getChannelKey(channelName);
            if (key == -1) {
                System.out.println("channel not found: " + channelName);
                return;
            }
            int startSec = Integer.parseInt(args[2]);
            int duration = Integer.parseInt(args[3]);
            int endSec = startSec + duration;
            System.out.println("getting data for " + channelName + " for " + duration + " seconds starting at " + startSec);
            this.ds.getData(key, startSec, endSec, this.handler);
            System.out.println("end of data");
        } else {
            System.out.println("usage:  data channelName startSec duration");
        }
    }

    protected void getSoh(String[] args) throws IOException {
        if (args.length > 3) {
            String channelName = args[1];
            int key = this.getChannelKey(channelName);
            if (key == -1) {
                System.out.println("channel not found: " + channelName);
                return;
            }
            int startSec = Integer.parseInt(args[2]);
            int duration = Integer.parseInt(args[3]);
            int endSec = startSec + duration;
            int bundleCount = args.length - 4;
            int[] bundles = new int[bundleCount];
            int ix = 0;
            while (ix < bundleCount) {
                bundles[ix] = Integer.parseInt(args[4 + ix]);
                ++ix;
            }
            System.out.println("getting soh for " + channelName + " for " + duration + " seconds starting at " + startSec + " (" + bundleCount + " bundles)");
            this.ds.getSoh(key, startSec, endSec, bundles, this.handler);
            System.out.println("end of data");
        } else {
            System.out.println("usage:  soh channelName startSec duration [bundle1] [bundle2] [...]");
        }
    }

    protected void getTimeSeries(String[] args) throws IOException {
        if (args.length > 3) {
            String channelName = args[1];
            int key = this.getChannelKey(channelName);
            if (key == -1) {
                System.out.println("channel not found: " + channelName);
                return;
            }
            int startSec = Integer.parseInt(args[2]);
            int duration = Integer.parseInt(args[3]);
            int endSec = startSec + duration;
            int sampleRate = 0;
            if (args.length > 4) {
                sampleRate = Integer.parseInt(args[4]);
            }
            System.out.println("getting time series for " + channelName + " for " + duration + " seconds starting at " + startSec + " at sample rate " + sampleRate);
            this.ds.getTimeSeries(key, startSec, endSec, sampleRate, this.handler);
            System.out.println("end of data");
        } else {
            System.out.println("usage:  ts channelName startSec duration [sampleRate]");
        }
    }

    protected void getTriggers(String[] args) throws IOException {
        if (args.length > 3) {
            String channelName = args[1];
            int key = 0;
            if (!channelName.equalsIgnoreCase("all")) {
                key = this.getChannelKey(channelName);
            }
            if (key == -1) {
                System.out.println("channel not found: " + channelName);
                return;
            }
            int startSec = Integer.parseInt(args[2]);
            int duration = Integer.parseInt(args[3]);
            int endSec = startSec + duration;
            System.out.println("getting triggers for " + channelName + " for " + duration + " seconds starting at " + startSec);
            this.ds.getTriggers(key, startSec, endSec, this.handler);
            System.out.println("end of triggers");
        } else {
            System.out.println("usage:  trigs channelName startSec duration");
        }
    }

    protected void getEvents(String[] args) throws IOException {
        if (args.length > 2) {
            int startSec = Integer.parseInt(args[1]);
            int duration = Integer.parseInt(args[2]);
            int endSec = startSec + duration;
            System.out.println("getting events for " + duration + " seconds starting at " + startSec);
            this.ds.getEvents(startSec, endSec, 0.0, this.handler);
            System.out.println("end of events");
        } else {
            System.out.println("usage:  events startSec duration");
        }
    }

    protected void showHelp() throws IOException {
        System.out.println("The following commands are supported:");
        System.out.println("  dcl    - display channel list");
        System.out.println("  gcl    - get channel list");
        System.out.println("  gpl    - get precis list");
        System.out.println("  dpl    - display precis list");
        System.out.println();
        System.out.println("  ch     - get channel header");
        System.out.println("  ds     - get data size");
        System.out.println("  yf     - get y5 file header for channel");
        System.out.println("  yfile  - extract yfile for channel and interval");
        System.out.println("  rf     - get response file for channel");
        System.out.println("  data   - get data");
        System.out.println("  soh    - get filtered soh");
        System.out.println("  ts     - get time series (decimated)");
        System.out.println("  trigs  - get triggers");
        System.out.println("  events - get events");
        System.out.println();
        System.out.println("  quit   - quit this program");
        System.out.println("  close  - close the data connection");
    }

    protected void processCmd(String[] args) throws IOException {
        String cmd = args[0].toLowerCase();
        if (cmd.equals("gcl")) {
            this.getChannelList();
        } else if (cmd.equals("dcl")) {
            this.displayChannelList();
        } else if (cmd.equals("gpl")) {
            this.getPrecisList(args);
        } else if (cmd.equals("dpl")) {
            this.displayPrecisList();
        } else if (cmd.equals("ch")) {
            this.getChannelHeader(args);
        } else if (cmd.equals("ds")) {
            this.getDataSize(args);
        } else if (cmd.equals("yf")) {
            this.getY5Header(args);
        } else if (cmd.equals("yfile")) {
            this.getY5File(args);
        } else if (cmd.equals("rf")) {
            this.getResponseFile(args);
        } else if (cmd.equals("data")) {
            this.getData(args);
        } else if (cmd.equals("soh")) {
            this.getSoh(args);
        } else if (cmd.equals("ts")) {
            this.getTimeSeries(args);
        } else if (cmd.equals("trigs") || cmd.equals("tr")) {
            this.getTriggers(args);
        } else if (cmd.equals("events") || cmd.equals("ev")) {
            this.getEvents(args);
        } else if (cmd.equals("quit") || cmd.equals("q")) {
            System.out.println("quitting... goodbye");
            this.ds.close();
            this.stayAlive = false;
        } else if (cmd.equals("close")) {
            System.out.println("closing ds");
            this.ds.close();
        } else if (cmd.equals("help") || cmd.equals("h")) {
            this.showHelp();
        } else {
            System.out.println("unknown command " + cmd);
            System.out.println("type help for help");
        }
    }

    public void go() {
        this.stayAlive = true;
        System.out.print(">");
        while (this.stayAlive) {
            try {
                String input = this.console.get(100);
                if (input == null) continue;
                if ((input = input.trim()).length() > 0) {
                    this.processCmd(this.makeArgs(input));
                }
                System.out.print(">");
            }
            catch (InterruptedException input) {
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (Exception any) {
                any.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        System.out.println("TestDataSource - test program for Nanometrics Data Service");
        System.out.println("copyright (C) Nanometrics, Inc., 2001");
        String name = "test";
        String passwd = "none";
        String host = "localhost";
        int port = 28002;
        if (args.length > 0 && args[0].startsWith("-")) {
            System.out.println("usage: TestDataSource [name [password [host [port]]]]");
            System.exit(0);
        }
        if (args.length > 0) {
            name = args[0];
        }
        if (args.length > 1) {
            passwd = args[1];
        }
        if (args.length > 2) {
            host = args[2];
        }
        if (args.length > 3) {
            port = Integer.parseInt(args[3]);
        }
        System.out.println("Connecting to " + host + ":" + port + " as " + name);
        TestDataSource tc = new TestDataSource(name, passwd, host, port);
        tc.go();
    }

    public class TrivialPacketConsumer
    implements PacketConsumer {
        public void processPacket(Packable packet) {
            System.out.println("Handler got " + packet);
        }
    }
}

