/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.nda.PacketConsumer;
import ca.nanometrics.packet.DataPacket;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.NmxDateFormat;
import ca.nanometrics.yfile.StnInfo;
import ca.nanometrics.yfile.Y5File;
import ca.nanometrics.yfile.Y5Header;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.LinkedList;

public class YFileBuilder
implements PacketConsumer {
    private Y5Header header;
    private int startTime;
    private int endTime;
    private int segmentSampleRate;
    private int segmentSampleCount;
    private double segmentStartTime;
    private double segmentEndTime;
    private LinkedList packets = new LinkedList();
    NmxDateFormat fmt = new NmxDateFormat("yyyyMMdd.HHmmss");

    public YFileBuilder(Y5Header y5Header, int startSec, int endSec) {
        this.header = y5Header;
        this.startTime = startSec;
        this.endTime = endSec;
        this.segmentSampleRate = 0;
        this.segmentSampleCount = 0;
        this.segmentStartTime = 0.0;
        this.segmentEndTime = 0.0;
    }

    public void processPacket(Packable packet) {
        if (packet instanceof DataPacket) {
            DataPacket dp = (DataPacket)packet;
            int pktSampleRate = dp.getSampleRate();
            double pktStartTime = dp.getStartTime();
            double sampleDiff = (double)pktSampleRate * (pktStartTime - this.segmentEndTime);
            if (this.segmentSampleRate != pktSampleRate || Math.abs(sampleDiff) > 0.5) {
                this.flush();
            }
            this.addPacket(dp);
        }
    }

    protected void addPacket(DataPacket dp) {
        double pktStartTime = dp.getStartTime();
        double pktEndTime = dp.getEndTime();
        if (pktStartTime < (double)this.endTime && pktEndTime > (double)this.startTime) {
            this.packets.add(dp);
            if (this.segmentSampleCount == 0) {
                this.segmentStartTime = pktStartTime;
                this.segmentEndTime = pktStartTime;
                this.segmentSampleRate = dp.getSampleRate();
            }
            int numSamples = dp.getNumSamples();
            this.segmentSampleCount += dp.getNumSamples();
            this.segmentEndTime = this.segmentStartTime + (double)this.segmentSampleCount / (double)this.segmentSampleRate;
        }
    }

    protected String createYFileName(Y5Header header, double startTime) {
        StnInfo stnInfo = header.getStnInfo();
        NmxDateFormat fmt = new NmxDateFormat("yyyyMMdd.HHmmss");
        String filename = "Y" + stnInfo.getStationName().toUpperCase() + stnInfo.getLocationName().toUpperCase() + "_" + stnInfo.getChannelName().toUpperCase() + "_" + fmt.format(startTime);
        return filename;
    }

    protected void writeYFile(Y5File yfile, String filename) {
        try {
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(filename)));
            yfile.writeTo(dos);
            dos.close();
        }
        catch (Exception any) {
            System.out.println("error writing yfile: " + filename);
            any.printStackTrace();
        }
    }

    public void flush() {
        if (this.segmentSampleCount > 0) {
            double rounder = 5.0E-5;
            Format fmt = new Format("%.9f");
            System.out.println("Writing YFile:");
            System.out.println("  StartTime:  " + fmt.form(this.segmentStartTime));
            System.out.println("  EndTime:    " + fmt.form(this.segmentEndTime));
            System.out.println("  SampleRate: " + this.segmentSampleRate);
            System.out.println("  NumSamples: " + this.segmentSampleCount);
            int startSkip = 0;
            System.out.println("diff (seconds) = " + ((double)this.startTime - this.segmentStartTime));
            System.out.println("diff (samples) = " + (double)this.segmentSampleRate * ((double)this.startTime - this.segmentStartTime));
            if (this.segmentStartTime < (double)this.startTime) {
                startSkip = (int)Math.ceil((double)this.segmentSampleRate * ((double)this.startTime - this.segmentStartTime - rounder));
            }
            this.segmentSampleCount -= startSkip;
            this.segmentStartTime += (double)startSkip / (double)this.segmentSampleRate;
            int endSkip = 0;
            if (this.segmentEndTime > (double)this.endTime) {
                endSkip = (int)((double)this.segmentSampleRate * (this.segmentEndTime + rounder - (double)this.endTime));
            }
            this.segmentSampleCount -= endSkip;
            this.segmentEndTime -= (double)endSkip / (double)this.segmentSampleRate;
            System.out.println("  StartSkip:  " + startSkip);
            System.out.println("  EndSkip:    " + endSkip);
            System.out.println("  StartTime:  " + fmt.form(this.segmentStartTime));
            System.out.println("  EndTime:    " + fmt.form(this.segmentEndTime));
            System.out.println("  SampleRate: " + this.segmentSampleRate);
            System.out.println("  NumSamples: " + this.segmentSampleCount);
            int[] samples = new int[this.segmentSampleCount];
            int offset = 0;
            Iterator iter = this.packets.iterator();
            while (iter.hasNext()) {
                DataPacket dp = (DataPacket)iter.next();
                int[] pktSamples = dp.getSamples();
                int numSamples = pktSamples.length;
                if (numSamples > startSkip) {
                    int samplesToCopy = numSamples - startSkip;
                    int maxToCopy = this.segmentSampleCount - offset;
                    if (samplesToCopy > maxToCopy) {
                        samplesToCopy = maxToCopy;
                    }
                    System.arraycopy(pktSamples, startSkip, samples, offset, samplesToCopy);
                    startSkip = 0;
                    offset += samplesToCopy;
                    continue;
                }
                startSkip -= numSamples;
            }
            System.out.println("  offset:   " + offset);
            Y5File yfile = new Y5File(this.header, samples, this.segmentStartTime, (double)this.segmentSampleRate);
            this.packets.clear();
            this.segmentSampleCount = 0;
            String filename = this.createYFileName(this.header, this.segmentStartTime);
            this.writeYFile(yfile, filename);
        }
    }
}

