/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.acq;

import ca.nanometrics.acq.IndexMap;
import ca.nanometrics.acq.MappedRange;
import ca.nanometrics.acq.Range;
import ca.nanometrics.acq.RangeList;
import java.util.Iterator;

public class RbfIndexTable {
    private RangeList list = new RangeList();
    private int capacity = 100;

    public void setCapacity(int numPackets) {
        this.capacity = numPackets;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int size() {
        return this.list.size();
    }

    public void clear() {
        this.list.clear();
    }

    public void addRange(int first, int last, int indexOfFirst) {
        MappedRange range;
        if (first <= last && !this.list.intersects(range = new MappedRange(first, last, indexOfFirst))) {
            this.list.add(range);
            this.trim();
        }
    }

    public void append(int sequence, int index) {
        MappedRange range = null;
        if (this.size() > 0) {
            range = (MappedRange)this.list.lastRange();
        }
        if (range != null && sequence < range.getEnd()) {
            this.clear();
        }
        if (this.size() > 0 && index == range.getIndexOf(sequence)) {
            range.setEnd(sequence);
            this.trim();
        } else {
            this.addRange(sequence, sequence, index);
        }
    }

    public int getFirstSequence() {
        if (this.size() > 0) {
            return this.list.firstStart();
        }
        return 0;
    }

    public IndexMap getIndexMap(int sequence) {
        return (IndexMap)((Object)this.list.getRange(sequence));
    }

    public void trim() {
        int count = this.capacity;
        Iterator iter = this.list.reverseIterator();
        while (count >= 0 && iter.hasNext()) {
            Range range = (Range)iter.next();
            if ((count -= range.size()) > 0) continue;
            this.list.clearBefore(range.getStart() - count);
            count = -1;
        }
    }
}

