/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.acq.fir;

import ca.nanometrics.acq.fir.FirStage;
import java.util.Enumeration;
import java.util.Vector;

public class FirCoeffs {
    private int numStages = 0;
    private int decimation = 1;
    private Vector stages = new Vector();

    public FirCoeffs(FirStage[] firStages) {
        if (firStages != null) {
            this.numStages = firStages.length;
            int i = 0;
            while (i < this.numStages) {
                this.decimation *= firStages[i].getDecimation();
                this.stages.addElement(firStages[i]);
                ++i;
            }
        }
    }

    public int getNumStages() {
        return this.numStages;
    }

    public int getDecimation() {
        return this.decimation;
    }

    public FirStage getStage(int index) {
        if (index < this.numStages) {
            return (FirStage)this.stages.elementAt(index);
        }
        return null;
    }

    public Enumeration elements() {
        return this.stages.elements();
    }
}

