/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.acq.fir;

import ca.nanometrics.acq.fir.FilterException;
import ca.nanometrics.acq.fir.FirCoeffs;
import ca.nanometrics.acq.fir.FirStage;
import java.util.Hashtable;

public class FirTable {
    private Hashtable filters = new Hashtable(10);
    private static final double[] DecimBy1_0 = new double[]{1.0};
    private static final double[] DecimBy3_0 = new double[]{6.0E-5, 2.6E-5, -6.2E-5, -1.91E-4, -2.64E-4, -1.83E-4, 5.3E-5, 2.96E-4, 3.34E-4, 7.0E-5, -3.48E-4, -5.8E-4, -3.56E-4, 2.56E-4, 8.07E-4, 7.79E-4, 4.3E-5, -9.17E-4, -0.001293, -6.04E-4, 7.83E-4, 0.001786, 0.001425, -2.75E-4, -0.002088, -0.002429, -6.97E-4, 0.001988, 0.003442, 0.002149, -0.00127, -0.0042, -0.003982, -2.43E-4, 0.004364, 0.005958, 0.002626, -0.003566, -0.007696, -0.005812, 0.00146, 0.008683, 0.009551, 0.002225, -0.008302, -0.013394, -0.00765, 0.005843, 0.016687, 0.014878, -4.53E-4, -0.018542, -0.023998, -0.009152, 0.017653, 0.03554, 0.025855, -0.011415, -0.052199, -0.060151, -0.01, 0.092526, 0.208568, 0.285243, 0.285243, 0.208568, 0.092526, -0.01, -0.060151, -0.052199, -0.011415, 0.025855, 0.03554, 0.017653, -0.009152, -0.023998, -0.018542, -4.53E-4, 0.014878, 0.016687, 0.005843, -0.00765, -0.013394, -0.008302, 0.002225, 0.009551, 0.008683, 0.00146, -0.005812, -0.007696, -0.003566, 0.002626, 0.005958, 0.004364, -2.43E-4, -0.003982, -0.0042, -0.00127, 0.002149, 0.003442, 0.001988, -6.97E-4, -0.002429, -0.002088, -2.75E-4, 0.001425, 0.001786, 7.83E-4, -6.04E-4, -0.001293, -9.17E-4, 4.3E-5, 7.79E-4, 8.07E-4, 2.56E-4, -3.56E-4, -5.8E-4, -3.48E-4, 7.0E-5, 3.34E-4, 2.96E-4, 5.3E-5, -1.83E-4, -2.64E-4, -1.91E-4, -6.2E-5, 2.6E-5, 6.0E-5};
    private static final double[] DecimBy6_0 = new double[]{6.587914E-5, 1.899969E-4, -4.827186E-5, -0.001216777, -0.002457607, -5.687041E-4, 0.006495283, 0.01294971, 0.00544901, -0.02159296, -0.04696462, -0.02711075, 0.06566507, 0.2029431, 0.3061833, 0.3061833, 0.2029431, 0.06566507, -0.02711075, -0.04696462, -0.02159296, 0.00544901, 0.01294971, 0.006495283, -5.687041E-4, -0.002457607, -0.001216777, -4.827186E-5, 1.899969E-4, 6.587914E-5};
    private static final double[] DecimBy6_1 = new double[]{-1.046905E-5, -2.377585E-5, -5.718979E-6, 3.423591E-5, 3.051089E-5, -4.393138E-5, -7.445012E-5, 3.356967E-5, 1.362692E-4, 1.277561E-5, -2.025092E-4, -1.122147E-4, 2.488128E-4, 2.730092E-4, -2.378789E-4, -4.882986E-4, 1.257253E-4, 7.273434E-4, 1.293681E-4, -9.317625E-4, -5.524018E-4, 0.001016527, 0.001135685, -8.796328E-4, -0.001823778, 4.200994E-4, 0.002504274, 4.363557E-4, -0.003008321, -0.001707706, 0.003124313, 0.003327176, -0.002625743, -0.005122464, 0.001311452, 0.006808534, 9.463453E-4, -0.007998371, -0.00415349, 0.008232391, 0.008152581, -0.007023114, -0.01259593, 0.003905999, 0.01693529, 0.001518937, -0.02042215, -0.009579908, 0.02209426, 0.02060824, -0.02067742, -0.03521951, 0.01417054, 0.05525585, 0.001904586, -0.08790202, -0.04504146, 0.182297, 0.4105864, 0.4105864, 0.182297, -0.04504146, -0.08790202, 0.001904586, 0.05525585, 0.01417054, -0.03521951, -0.02067742, 0.02060824, 0.02209426, -0.009579908, -0.02042215, 0.001518937, 0.01693529, 0.003905999, -0.01259593, -0.007023114, 0.008152581, 0.008232391, -0.00415349, -0.007998371, 9.463453E-4, 0.006808534, 0.001311452, -0.005122464, -0.002625743, 0.003327176, 0.003124313, -0.001707706, -0.003008321, 4.363557E-4, 0.002504274, 4.200994E-4, -0.001823778, -8.796328E-4, 0.001135685, 0.001016527, -5.524018E-4, -9.317625E-4, 1.293681E-4, 7.273434E-4, 1.257253E-4, -4.882986E-4, -2.378789E-4, 2.730092E-4, 2.488128E-4, -1.122147E-4, -2.025092E-4, 1.277561E-5, 1.362692E-4, 3.356967E-5, -7.445012E-5, -4.393138E-5, 3.051089E-5, 3.423591E-5, -5.718979E-6, -2.377585E-5, -1.046905E-5};

    public FirTable() {
        FirStage Stage1_0 = new FirStage(DecimBy1_0, 1);
        FirStage[] DecimByOneStages = new FirStage[]{Stage1_0};
        this.addFilter(DecimByOneStages);
        FirStage Stage3_0 = new FirStage(DecimBy3_0, 3);
        FirStage[] DecimByThreeStages = new FirStage[]{Stage3_0};
        this.addFilter(DecimByThreeStages);
        FirStage Stage6_0 = new FirStage(DecimBy6_0, 3);
        FirStage Stage6_1 = new FirStage(DecimBy6_1, 2);
        FirStage[] DecimBySixStages = new FirStage[]{Stage6_0, Stage6_1};
        this.addFilter(DecimBySixStages);
    }

    private void addFilter(FirStage[] firStages) {
        FirCoeffs fc = new FirCoeffs(firStages);
        this.filters.put(new Integer(fc.getDecimation()), fc);
    }

    public FirCoeffs getFirCoeffs(int inputRate, int outputRate) throws FilterException {
        if (inputRate % outputRate == 0) {
            int decimation = inputRate / outputRate;
            Integer key = new Integer(decimation);
            if (this.filters.containsKey(key)) {
                return (FirCoeffs)this.filters.get(key);
            }
            throw new FilterException("No such filter exists.");
        }
        throw new FilterException("Decimation = inputRate/outputRate must be an integer.");
    }
}

