/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.dataServer.test;

import ca.nanometrics.msg.ChannelList;
import ca.nanometrics.nda.NmxDataSource;
import ca.nanometrics.nda.PacketConsumer;
import ca.nanometrics.nda.TcpDataSource;
import ca.nanometrics.packet.DataPacket;
import ca.nanometrics.packet.Packable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class AccessDataServer {
    private static final double MILLSECS_PER_SEC = 1000.0;
    private NmxDataSource m_dataSource;
    private ChannelList channelList = null;

    public AccessDataServer(String name, String password, String host, int port) {
        this.m_dataSource = new TcpDataSource(host, port, name, password);
    }

    protected void assertChannelListExists() throws IOException {
        if (this.channelList == null) {
            this.channelList = this.m_dataSource.getChannelList();
        }
        if (this.channelList == null) {
            throw new IOException("cannot obtain channel list");
        }
    }

    protected void getChannelListFromDataServer() throws IOException {
        this.channelList = this.m_dataSource.getChannelList();
    }

    public ChannelList getChannelList() throws IOException {
        this.assertChannelListExists();
        return this.channelList;
    }

    protected int getChannelKey(String name) throws IOException {
        this.assertChannelListExists();
        return this.channelList.getKeyOf(name.toUpperCase());
    }

    public int getSampleRate(String channelName, double startTime) throws IOException {
        SampleRateDataConsumer dataConsumer = new SampleRateDataConsumer();
        int key = this.getChannelKey(channelName);
        this.m_dataSource.getData(key, this.intTime(startTime), this.intTime(startTime), dataConsumer);
        return dataConsumer.getSampleRate();
    }

    public int[] getData(String channelName, double startTime, double endTime) throws IOException {
        int key = this.getChannelKey(channelName);
        ArrayList sampleList = new ArrayList();
        TraceDataConsumer dataConsumer = new TraceDataConsumer(sampleList, startTime, endTime);
        this.m_dataSource.getData(key, this.intTime(startTime), this.intTime(endTime) + 1, dataConsumer);
        int numberOfSamples = this.calculateNumberOfSamples(channelName, startTime, endTime);
        return this.createArray(sampleList, numberOfSamples);
    }

    protected int calculateNumberOfSamples(String channelName, double startTime, double endTime) throws IOException {
        int sampleRate = this.getSampleRate(channelName, startTime);
        double alignedStartTime = this.calculateAlignedTimeOfSample(startTime / 1000.0, sampleRate);
        double alignedEndTime = this.calculateAlignedTimeOfSample(endTime / 1000.0, sampleRate);
        double duration = alignedEndTime - alignedStartTime + 5.0E-4;
        return (int)(duration * (double)sampleRate);
    }

    protected int[] createArray(ArrayList sampleList, int numberOfSamples) {
        int[] array = new int[numberOfSamples];
        int startIndex = 0;
        Iterator i = sampleList.iterator();
        while (i.hasNext()) {
            int[] packetArray = (int[])i.next();
            System.arraycopy(packetArray, 0, array, startIndex, packetArray.length);
            startIndex += packetArray.length;
        }
        return array;
    }

    private int intTime(double time) {
        int newTime = time / 1000.0 > 2.147483647E9 ? Integer.MAX_VALUE : (time / 1000.0 < 0.0 ? 0 : (int)(time / 1000.0));
        return newTime;
    }

    protected double calculateAlignedTimeOfSample(double sampleTime, int sampleRate) {
        double timeSteps = 10000.0 / (double)sampleRate;
        int fracSteps = (int)((sampleTime += 5.0E-5) * 10000.0 % 10000.0 / timeSteps);
        int startTimeSecs = (int)sampleTime;
        return (double)startTimeSecs + 1.0E-4 * (double)fracSteps * timeSteps;
    }

    public class SampleRateDataConsumer
    implements PacketConsumer {
        private int m_sampleRate;

        public void processPacket(Packable packet) {
            if (!(packet instanceof DataPacket)) {
                return;
            }
            DataPacket data = (DataPacket)packet;
            this.setSampleRate(data.getSampleRate());
        }

        public int getSampleRate() {
            return this.m_sampleRate;
        }

        public void setSampleRate(int sampleRate) {
            this.m_sampleRate = sampleRate;
        }
    }

    public class TraceDataConsumer
    implements PacketConsumer {
        private ArrayList m_list;
        private double m_startTime;
        private double m_endTime;

        public TraceDataConsumer(ArrayList arrayList, double startTime, double endTime) {
            this.m_list = arrayList;
            this.m_startTime = startTime / 1000.0;
            this.m_endTime = endTime / 1000.0;
        }

        public void processPacket(Packable packet) {
            if (!(packet instanceof DataPacket)) {
                return;
            }
            DataPacket data = (DataPacket)packet;
            int[] intSamps = data.getSamples();
            int sampleRate = data.getSampleRate();
            double packetStart = data.getStartTime();
            double packetEnd = data.getEndTime();
            int firstIndex = 0;
            int lastIndex = intSamps.length - 1;
            if (packetStart > this.getEndTime()) {
                return;
            }
            if (packetEnd < this.getStartTime()) {
                return;
            }
            if (this.isFirstPacket(packetStart, packetEnd)) {
                firstIndex = this.calculateFirstSampleInTimeRange(packetStart, sampleRate);
                packetStart = this.m_startTime;
            }
            if (this.isLastPacket(packetStart, packetEnd)) {
                lastIndex = this.calculateNumberOfSamplesInEndTimeRange(packetStart, sampleRate) - 1;
            }
            if (lastIndex < firstIndex) {
                return;
            }
            int[] samples = new int[lastIndex - firstIndex + 1];
            int index = firstIndex;
            while (index <= lastIndex) {
                samples[index - firstIndex] = intSamps[index];
                ++index;
            }
            this.m_list.add(samples);
        }

        private boolean isFirstPacket(double packetStartTime, double packetEndTime) {
            return packetStartTime <= this.getStartTime() && packetEndTime >= this.getStartTime();
        }

        private boolean isLastPacket(double packetEndTime, double payloadEndTime) {
            return packetEndTime <= this.getEndTime() && payloadEndTime >= this.getEndTime();
        }

        protected int calculateNumberOfSamplesInEndTimeRange(double packetTime, int sampleRate) {
            double alignedPacketTime = AccessDataServer.this.calculateAlignedTimeOfSample(packetTime, sampleRate);
            double alignedEndTime = AccessDataServer.this.calculateAlignedTimeOfSample(this.getEndTime(), sampleRate);
            double timeFromStartTime = alignedEndTime - alignedPacketTime;
            return (int)Math.round(timeFromStartTime * (double)sampleRate);
        }

        protected int calculateFirstSampleInTimeRange(double packetTime, int sampleRate) {
            double alignedPacketTime = AccessDataServer.this.calculateAlignedTimeOfSample(packetTime, sampleRate);
            double alignedStartTime = AccessDataServer.this.calculateAlignedTimeOfSample(this.getStartTime(), sampleRate);
            double timeFromStartTime = alignedStartTime - alignedPacketTime;
            return (int)Math.round(timeFromStartTime * (double)sampleRate);
        }

        public double getEndTime() {
            return this.m_endTime;
        }

        public double getStartTime() {
            return this.m_startTime;
        }
    }
}

