/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.dataServer.test;

import ca.nanometrics.dataServer.test.AccessDataServer;
import ca.nanometrics.msg.ChannelList;
import java.io.IOException;
import junit.framework.TestCase;

public class AccessDataServerTest
extends TestCase {
    private static final long START_TIME = 1129140960000L;
    private static final long END_TIME = 1129141080000L;
    private static final String CHANNEL = "T270.BTE";
    private AccessDataServer m_dataServer;

    public void setUp() {
        this.m_dataServer = new AccessDataServer("rob", "rob", "localhost", 28002);
    }

    public void testGetChannelList() throws Exception {
        ChannelList channelList = this.m_dataServer.getChannelList();
        AccessDataServerTest.assertNotNull((Object)channelList);
        AccessDataServerTest.assertEquals((String)"Size", (int)64, (int)channelList.getChannelKeys().length);
    }

    public void testGetSampleRate() throws Exception {
        int sampleRate = this.m_dataServer.getSampleRate(CHANNEL, 1.12914096E12);
        AccessDataServerTest.assertEquals((int)500, (int)sampleRate);
    }

    public void testGetNumberOfSamples() throws Exception {
        AccessDataServerTest.assertEquals((int)60000, (int)this.m_dataServer.calculateNumberOfSamples(CHANNEL, 1.12914096E12, 1.12914108E12));
        AccessDataServerTest.assertEquals((int)60222, (int)this.m_dataServer.calculateNumberOfSamples(CHANNEL, 1.12914096E12, 1.129141080444E12));
        AccessDataServerTest.assertEquals((int)60250, (int)this.m_dataServer.calculateNumberOfSamples(CHANNEL, 1.12914096E12, 1.1291410805E12));
        AccessDataServerTest.assertEquals((int)60250, (int)this.m_dataServer.calculateNumberOfSamples(CHANNEL, 1.1291409595E12, 1.12914108E12));
        AccessDataServerTest.assertEquals((int)66168, (int)this.m_dataServer.calculateNumberOfSamples("DUN4.BTE", 1.12925876916E12, 1.12925943084E12));
    }

    public void testGetData() throws Exception {
        this.runGetDataTest(CHANNEL, 1129140960000L, 1129141080000L, 60000);
        this.runGetDataTest(CHANNEL, 1129140960000L, 1129141080444L, 60222);
        this.runGetDataTest(CHANNEL, 1129140960000L, 1129141080500L, 60250);
        this.runGetDataTest(CHANNEL, 1129140959500L, 1129141080000L, 60250);
        this.runGetDataTest("DUN4.BTE", 1129258769160L, 1129259430840L, 66168);
    }

    private void runGetDataTest(String channel, long startTime, long endTime, int expectedNumberOfSamplesSamples) throws IOException {
        int[] samples = this.m_dataServer.getData(channel, startTime, endTime);
        AccessDataServerTest.assertNotNull((Object)samples);
        AccessDataServerTest.assertEquals((int)expectedNumberOfSamplesSamples, (int)samples.length);
    }
}

