/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Header {
    protected static final String ID_CHARSET = "UTF-8";

    public static void writeID(DataOutput file, String idString) throws IOException {
        file.write(idString.getBytes(ID_CHARSET));
    }

    public static String readString(DataInput file, int stringLength) throws IOException {
        byte[] readBytes = new byte[stringLength];
        file.readFully(readBytes);
        String readString = Header.makeString(readBytes);
        return readString;
    }

    public static boolean verifyID(DataInput file, String idString) throws IOException {
        String readString = Header.readString(file, idString.length());
        return readString.equals(idString);
    }

    public static int whichID(DataInput file, String[] idStrings) throws IOException {
        if (idStrings.length < 1) {
            return -1;
        }
        if (idStrings.length == 1) {
            if (Header.verifyID(file, idStrings[0])) {
                return 0;
            }
            return -1;
        }
        String readString = Header.readString(file, idStrings[0].length());
        int i = 0;
        while (i < idStrings.length) {
            if (readString.equals(idStrings[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String makeString(byte[] bytes) throws IOException {
        return new String(bytes, ID_CHARSET);
    }
}

