/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.io;

import ca.nanometrics.io.RandomAccessIF;
import java.io.DataInput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;

public class MappedRandomAccessFile
extends RandomAccessFile
implements RandomAccessIF,
Comparable {
    private static final String ID_CHARSET = "UTF-8";
    private VolumeHeader m_volumeHeader = null;
    String m_name;

    public static long getHeaderSize() {
        return 36L;
    }

    public MappedRandomAccessFile(String fileName) throws FileNotFoundException, IOException {
        super(fileName, "rw");
        this.m_name = fileName;
        this.m_volumeHeader = new VolumeHeader(this);
    }

    public MappedRandomAccessFile(String fileName, long startOffset, long volumeSize, boolean isLastFile, long chainId) throws FileNotFoundException, IOException {
        super(fileName, "rw");
        this.m_name = fileName;
        long actualVolumeSize = volumeSize + MappedRandomAccessFile.getHeaderSize();
        this.m_volumeHeader = new VolumeHeader(startOffset, actualVolumeSize, isLastFile, chainId);
        this.m_volumeHeader.write(this);
        this.setLength(actualVolumeSize);
    }

    /*
     * Unable to fully structure code
     */
    public void setLength(long size) throws IOException {
        block4: {
            try {
                super.setLength(size);
                break block4;
            }
            catch (Exception e) {
                currentSize = this.getSize();
                if (currentSize < 0L) {
                    currentSize = 0L;
                }
                buffer = new byte[102400];
                Arrays.fill(buffer, (byte)-1);
                runs = (size - currentSize) / (long)buffer.length;
                leftover = (int)((size - currentSize) % (long)buffer.length);
                i = 0;
                ** while ((long)i < runs)
            }
lbl-1000:
            // 1 sources

            {
                this.write(buffer);
                ++i;
                continue;
            }
lbl17:
            // 1 sources

            buffer = new byte[leftover];
            Arrays.fill(buffer, (byte)-1);
            this.write(buffer);
        }
    }

    public String getName() {
        return this.m_name;
    }

    public long getGlobalStartPtr() {
        return this.m_volumeHeader.getStartOffset();
    }

    public long getGlobalEndPtr() {
        return this.m_volumeHeader.getStartOffset() + this.m_volumeHeader.getVolumeSize() - this.m_volumeHeader.length();
    }

    public boolean contains(long position) {
        return position >= this.getGlobalStartPtr() && position < this.getGlobalEndPtr();
    }

    public boolean isTheLastFile() {
        return this.m_volumeHeader.isLastFile();
    }

    public void seek(long globalPos) throws IOException {
        super.seek(globalPos - this.getGlobalStartPtr() + this.m_volumeHeader.length());
    }

    public int compareTo(Object aFile) {
        MappedRandomAccessFile otherFile = (MappedRandomAccessFile)aFile;
        if (this.m_volumeHeader.getStartOffset() < otherFile.m_volumeHeader.getStartOffset()) {
            return -1;
        }
        if (this.m_volumeHeader.getStartOffset() == otherFile.m_volumeHeader.getStartOffset()) {
            return 0;
        }
        return 1;
    }

    public long getDatalength() {
        return this.m_volumeHeader.getVolumeSize() - this.m_volumeHeader.length();
    }

    public void flush() throws IOException {
        this.getFD().sync();
    }

    public long getPointer() throws IOException {
        return this.getFilePointer();
    }

    public long getSize() throws IOException {
        return super.length();
    }

    public class VolumeHeader {
        private static final String START_ID = "NMXV";
        private static final String FOOTER_ID = "VOLF";
        private static final long HEADER_LENGTH = 36L;
        private long m_startOffset = 0L;
        private long m_volumeSize;
        private boolean m_isLastFile = false;
        private long m_chainID;
        private boolean m_isHeaderFromFile = false;

        public VolumeHeader(long startOffset, long size, boolean isLastFile, long chainId) {
            this.setStartOffset(startOffset);
            this.setVolumeSize(size);
            this.setLastFile(isLastFile);
            this.setChainID(chainId);
            this.m_isHeaderFromFile = false;
        }

        public VolumeHeader(RandomAccessFile file) throws IOException {
            this.read(file);
            this.m_isHeaderFromFile = true;
        }

        public void write(RandomAccessFile file) throws IOException {
            this.verifyWritable();
            file.write(START_ID.getBytes(MappedRandomAccessFile.ID_CHARSET));
            file.writeLong(this.getStartOffset());
            file.writeLong(this.getVolumeSize());
            file.writeInt(this.isLastFile() ? 1 : 0);
            file.writeLong(this.getChainID());
            file.write(FOOTER_ID.getBytes(MappedRandomAccessFile.ID_CHARSET));
        }

        private void verifyWritable() throws IOException {
            if (this.m_isHeaderFromFile) {
                throw new IOException("Closed segment cannot be updated!");
            }
        }

        private void read(RandomAccessFile file) throws IOException {
            this.verifyID(file, START_ID);
            this.setStartOffset(file.readLong());
            this.setVolumeSize(file.readLong());
            this.setLastFile(file.readInt() != 0);
            this.setChainID(file.readLong());
            this.verifyID(file, FOOTER_ID);
        }

        public long length() {
            return 36L;
        }

        public long getVolumeSize() {
            return this.m_volumeSize;
        }

        public void setVolumeSize(long volumeSize) {
            this.m_volumeSize = volumeSize;
        }

        public void setStartOffset(long startOffset) {
            this.m_startOffset = startOffset;
        }

        public long getStartOffset() {
            return this.m_startOffset;
        }

        public boolean isLastFile() {
            return this.m_isLastFile;
        }

        public void setLastFile(boolean b) {
            this.m_isLastFile = b;
        }

        private void setChainID(long chainID) {
            this.m_chainID = chainID;
        }

        public long getChainID() {
            return this.m_chainID;
        }

        private boolean verifyID(DataInput file, String idString) throws IOException {
            byte[] readBytes = new byte[idString.length()];
            file.readFully(readBytes);
            String readString = this.makeString(readBytes);
            return readString.equals(idString);
        }

        private String makeString(byte[] bytes) throws IOException {
            return new String(bytes, MappedRandomAccessFile.ID_CHARSET);
        }
    }
}

