/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.io;

import ca.nanometrics.io.NmxDataOutputIF;
import ca.nanometrics.io.StreamOutputListenerIF;
import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;

public class NmxDataOutputStream
extends FilterOutputStream
implements NmxDataOutputIF {
    private URI m_baseURI;
    private Vector writeListeners = new Vector();
    protected int written;

    public NmxDataOutputStream(OutputStream out, URI base) {
        super(out);
        this.setBaseURI(base);
    }

    public NmxDataOutputStream(OutputStream out) {
        this(out, null);
    }

    public NmxDataOutputStream(NmxDataOutputStream clone, OutputStream out) {
        this(out, clone.getBaseURI());
    }

    public synchronized void setBaseURI(URI base) {
        this.m_baseURI = base;
    }

    public URI getBaseURI() {
        return this.m_baseURI;
    }

    public synchronized void writeURI(URI data) throws IOException {
        NmxDataOutputStream.writeURI(this, this.m_baseURI, data);
    }

    public synchronized void writeURL(URL data) throws IOException {
        NmxDataOutputStream.writeURL(this, data);
    }

    public synchronized void addOutputListener(StreamOutputListenerIF obs) {
        this.writeListeners.add(obs);
    }

    public synchronized void removeOutputListener(StreamOutputListenerIF obs) {
        this.writeListeners.remove(obs);
    }

    public NmxDataOutputIF cloneStream(OutputStream stream) {
        return new NmxDataOutputStream(this, stream);
    }

    public synchronized void write(int b) throws IOException {
        this.out.write(b);
        this.incCount(1);
        if (this.writeListeners.size() > 0) {
            Iterator iter = this.writeListeners.iterator();
            byte[] byteArray = new byte[]{(byte)b};
            while (iter.hasNext()) {
                ((StreamOutputListenerIF)iter.next()).bytesWrittenNotify(byteArray);
            }
        }
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.incCount(len);
        if (this.writeListeners.size() > 0) {
            Iterator iter = this.writeListeners.iterator();
            byte[] byteArray = new byte[len];
            System.arraycopy(b, off, byteArray, 0, len);
            while (iter.hasNext()) {
                ((StreamOutputListenerIF)iter.next()).bytesWrittenNotify(byteArray);
            }
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    public void writeShort(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public void writeChar(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public void writeInt(int v) throws IOException {
        this.write(v >>> 24 & 0xFF);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public void writeLong(long v) throws IOException {
        this.write((int)(v >>> 56) & 0xFF);
        this.write((int)(v >>> 48) & 0xFF);
        this.write((int)(v >>> 40) & 0xFF);
        this.write((int)(v >>> 32) & 0xFF);
        this.write((int)(v >>> 24) & 0xFF);
        this.write((int)(v >>> 16) & 0xFF);
        this.write((int)(v >>> 8) & 0xFF);
        this.write((int)(v >>> 0) & 0xFF);
    }

    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public void writeBytes(String s) throws IOException {
        int len = s.length();
        int i = 0;
        while (i < len) {
            this.write((byte)s.charAt(i));
            ++i;
        }
    }

    public void writeChars(String s) throws IOException {
        int len = s.length();
        int i = 0;
        while (i < len) {
            char v = s.charAt(i);
            this.write(v >>> 8 & 0xFF);
            this.write(v >>> 0 & 0xFF);
            ++i;
        }
    }

    public void writeUTF(String str) throws IOException {
        NmxDataOutputStream.writeUTF(str, this);
    }

    public int size() {
        return this.written;
    }

    static void writeURI(DataOutput stream, URI base, URI data) throws IOException {
        URI newData;
        boolean wasRelativized = false;
        if (base != null && !(newData = base.relativize(data)).equals(data)) {
            data = newData;
            wasRelativized = true;
        }
        stream.writeBoolean(wasRelativized);
        stream.writeUTF(data == null ? "" : data.toString());
    }

    static void writeURL(DataOutput stream, URL data) throws IOException {
        stream.writeUTF(data == null ? "" : data.toString());
    }

    public static int writeUTF(String str, DataOutput out) throws IOException {
        char c;
        int strlen = str.length();
        int utflen = 0;
        char[] charr = new char[strlen];
        int count = 0;
        str.getChars(0, strlen, charr, 0);
        int i = 0;
        while (i < strlen) {
            c = charr[i];
            utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        byte[] bytearr = new byte[utflen + 2];
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
        int i2 = 0;
        while (i2 < strlen) {
            c = charr[i2];
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i2;
        }
        out.write(bytearr);
        return utflen + 2;
    }

    private void incCount(int value) {
        int temp = this.written + value;
        if (temp < 0) {
            temp = Integer.MAX_VALUE;
        }
        this.written = temp;
    }
}

