/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.msg;

import ca.nanometrics.packet.LogPacket;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;
import java.util.Date;

public class CalibrationEventMessage
implements Packable {
    public static final int MSG_TYPE = 194;
    int instrumentID;
    Date msgTime;
    String msg;
    String identifier;

    public CalibrationEventMessage(int instrumentID, String msg, String identifier) {
        this.instrumentID = instrumentID;
        this.msgTime = new Date();
        this.msg = new String(msg);
        this.identifier = new String(identifier);
    }

    public CalibrationEventMessage(LogPacket lp) throws InvalidInputException {
        this.instrumentID = lp.getInstrumentID();
        this.msgTime = new Date((long)lp.getPacketTime() * 1000L);
        String logMessage = lp.getMessage();
        if (logMessage.startsWith(".*Calibration")) {
            throw new InvalidInputException("Must start with 'Calibration' keyword");
        }
        this.parseMessageContents(logMessage);
    }

    public CalibrationEventMessage(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    public int getInstrumentID() {
        return this.instrumentID;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getMsg() {
        return this.msg;
    }

    public Date getMsgTime() {
        return this.msgTime;
    }

    public void setMsg(String newMsg) {
        this.msg = newMsg;
    }

    public void setMsgTime(Date date) {
        this.msgTime = date;
    }

    public int getDataType() {
        return 194;
    }

    public void writeTo(byte[] buffer, int offset) {
        BigEndian.writeInt(buffer, offset, this.instrumentID);
        BigEndian.writeLong(buffer, offset += 4, this.msgTime.getTime());
        BigEndian.writeString(buffer, offset += 8, this.msg, buffer.length);
        BigEndian.writeString(buffer, offset += this.msg.getBytes().length + 1, this.identifier, buffer.length);
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        if (buffer.length - offset < 20) {
            throw new InvalidInputException("Not enough bytes to read");
        }
        this.instrumentID = BigEndian.readInt(buffer, offset);
        this.msgTime = new Date(BigEndian.readLong(buffer, offset += 4));
        this.msg = BigEndian.readString(buffer, offset += 8, length);
        this.identifier = BigEndian.readString(buffer, offset += this.msg.getBytes().length + 1, length);
    }

    public int getDataLength() {
        return 12 + this.msg.getBytes().length + 1 + this.identifier.getBytes().length + 1;
    }

    public boolean isRejectionMessage() {
        return this.msg.matches(".*rejected.*");
    }

    public boolean isStopMessage() {
        return this.msg.matches(".*finished.*") || this.msg.matches(".*aborted.*");
    }

    public boolean isStartMessage() {
        return this.msg.matches(".*started.*");
    }

    public String toString() {
        return "CalibrationEventMessage: " + this.msg;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CalibrationEventMessage) {
            CalibrationEventMessage equalMessage = (CalibrationEventMessage)obj;
            if (this.getInstrumentID() != equalMessage.getInstrumentID()) {
                return false;
            }
            if (!this.getMsgTime().equals(equalMessage.getMsgTime())) {
                return false;
            }
            if (!this.getMsg().equals(equalMessage.getMsg())) {
                return false;
            }
            return this.getIdentifier().equals(equalMessage.getIdentifier());
        }
        return false;
    }

    private void parseMessageContents(String logMessage) {
        String[] splitString = logMessage.split("<\\/*[iI][dD]>");
        if (splitString.length < 3) {
            this.msg = new String(logMessage);
            this.identifier = new String("unknown");
        } else {
            this.identifier = new String(splitString[1].trim());
            this.msg = new String(splitString[2].trim());
        }
    }
}

