/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.msg;

import ca.nanometrics.packet.ChannelKey;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;

public class CalibrationInfo {
    private static final int INT_SIZE = 4;
    private static final int FLOAT_SIZE = 4;
    private static final int BYTE_SIZE = 1;
    private static final int TYPE_LENGTH = 16;
    private static final int NAME_LENGTH = 12;
    public static final int HRD_SOURCE = 0;
    public static final int TRIDENT_SOURCE = 1;
    public static final int CURRENT_CAL = 0;
    public static final int VOLTAGE_CAL = 1;
    private int key;
    private String channelName;
    private int mcEnable;
    private double mcDuration = 1.0;
    private int calEnable;
    private int calRelay;
    private int calUnits;
    private double coilResistance;
    private double coilConstant;
    private String sensorName;
    private int calSource;

    public CalibrationInfo(int theKey, String theName, int theMcEnable, double theMcDuration, int theCalEnable, int theCalRelay, String theCalUnits, double theCoilResistance, double theCoilConstant, String theSensorName, int theCalSource) {
        this.key = theKey;
        this.channelName = theName;
        this.mcEnable = theMcEnable;
        this.mcDuration = theMcDuration;
        this.calEnable = theCalEnable;
        this.calRelay = theCalRelay;
        this.calUnits = theCalUnits.equalsIgnoreCase("Volts") ? 1 : 0;
        this.coilResistance = theCoilResistance;
        this.coilConstant = theCoilConstant;
        this.sensorName = theSensorName;
        this.calSource = theCalSource;
    }

    public CalibrationInfo(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    public void writeTo(byte[] buffer, int offset) {
        BigEndian.writeInt(buffer, offset, this.key);
        BigEndian.writeString(buffer, offset += 4, this.channelName, 12);
        buffer[offset += 12] = (byte)this.mcEnable;
        buffer[++offset] = (byte)this.calEnable;
        buffer[++offset] = (byte)this.calRelay;
        buffer[++offset] = (byte)this.calUnits;
        BigEndian.writeFloat(buffer, ++offset, (float)this.coilResistance);
        BigEndian.writeFloat(buffer, offset += 4, (float)this.coilConstant);
        BigEndian.writeString(buffer, offset += 4, this.sensorName, 16);
        BigEndian.writeFloat(buffer, offset += 16, (float)this.mcDuration);
        BigEndian.writeInt(buffer, offset += 4, this.calSource);
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        if (offset + this.getDataLength() > buffer.length || this.getDataLength() > length) {
            throw new InvalidInputException("insufficient data in CalibrationInfo.readFrom()");
        }
        this.key = BigEndian.readInt(buffer, offset);
        this.channelName = BigEndian.readString(buffer, offset += 4, 12);
        this.mcEnable = buffer[offset += 12];
        this.calEnable = buffer[++offset];
        this.calRelay = buffer[++offset];
        this.calUnits = buffer[++offset];
        this.coilResistance = BigEndian.readFloat(buffer, ++offset);
        this.coilConstant = BigEndian.readFloat(buffer, offset += 4);
        this.sensorName = BigEndian.readString(buffer, offset += 4, 16);
        this.mcDuration = BigEndian.readFloat(buffer, offset += 16);
        this.calSource = BigEndian.readInt(buffer, offset += 4);
    }

    public int getDataLength() {
        return 52;
    }

    public int getKey() {
        return this.key;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public int getMassCenterEnable() {
        return this.mcEnable;
    }

    public double getMassCenterDuration() {
        return this.mcDuration;
    }

    public int getCalEnable() {
        return this.calEnable;
    }

    public int getCalRelay() {
        return this.calRelay & 7;
    }

    public boolean isSharedCoil() {
        return (this.calRelay & 8) != 0;
    }

    public int getCalUnits() {
        return this.calUnits;
    }

    public double getCoilResistance() {
        return this.coilResistance;
    }

    public double getCoilConstant() {
        return this.coilConstant;
    }

    public String getSensorName() {
        return this.sensorName;
    }

    public int getCalSource() {
        return this.calSource;
    }

    public int getInstrumentID() {
        return ChannelKey.getIDOf(this.getKey());
    }
}

