/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.msg;

import ca.nanometrics.msg.CalibrationEventMessage;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class CalibrationList
implements Packable {
    public static final int MSG_TYPE = 194;
    public static final int NO_KEY = -1;
    private HashMap calibrationTable = new HashMap();

    public CalibrationList() {
    }

    public CalibrationList(byte[] buffer, int offset, int length) throws InvalidInputException {
        this();
        this.readFrom(buffer, offset, length);
    }

    public CalibrationEventMessage getMessage(String identifier) {
        Iterator iter = this.messageIterator();
        while (iter.hasNext()) {
            CalibrationEventMessage cem = (CalibrationEventMessage)iter.next();
            String curID = cem.getIdentifier();
            if (!curID.equals(identifier)) continue;
            return cem;
        }
        return null;
    }

    public CalibrationEventMessage getMessage(int instrumentID) {
        Iterator iter = this.messageIterator();
        while (iter.hasNext()) {
            CalibrationEventMessage cem = (CalibrationEventMessage)iter.next();
            int curID = cem.getInstrumentID();
            if (curID != instrumentID) continue;
            return cem;
        }
        return null;
    }

    public Date getExpiry(CalibrationEventMessage cem) {
        return (Date)this.calibrationTable.get(cem);
    }

    public CalibrationEventMessage getCalibrationEventMessage(String identifier) {
        CalibrationEventMessage cem = this.getMessage(identifier);
        return cem;
    }

    public void add(int instrumentID, String msg, String identifier, Date expireDate) {
        CalibrationEventMessage cem = new CalibrationEventMessage(instrumentID, msg, identifier);
        this.add(cem, expireDate);
    }

    public void add(CalibrationEventMessage cle, Date expireDate) {
        this.remove(cle.getIdentifier());
        this.calibrationTable.put(cle, expireDate);
    }

    public void remove(String identifier) {
        CalibrationEventMessage removeMessage = this.getMessage(identifier);
        if (removeMessage != null) {
            this.remove(removeMessage);
        }
    }

    public void remove(CalibrationEventMessage removeMessage) {
        this.calibrationTable.remove(removeMessage);
    }

    public int size() {
        return this.calibrationTable.size();
    }

    public boolean contains(String identifier) {
        Iterator iter = this.messageIterator();
        while (iter.hasNext()) {
            CalibrationEventMessage event = (CalibrationEventMessage)iter.next();
            if (!event.getIdentifier().equals(identifier)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(int instrumentID) {
        Iterator iter = this.messageIterator();
        while (iter.hasNext()) {
            CalibrationEventMessage event = (CalibrationEventMessage)iter.next();
            if (event.getInstrumentID() != instrumentID) continue;
            return true;
        }
        return false;
    }

    public boolean isExpired(CalibrationEventMessage message) {
        Date expiryDate = this.getExpiry(message);
        return expiryDate != null && expiryDate.before(new Date());
    }

    public void removeExpired() {
        Iterator iter = this.messageIterator();
        while (iter.hasNext()) {
            CalibrationEventMessage cem = (CalibrationEventMessage)iter.next();
            if (!this.isExpired(cem)) continue;
            iter.remove();
        }
    }

    public void clear() {
        this.calibrationTable.clear();
    }

    public Iterator messageIterator() {
        return this.calibrationTable.keySet().iterator();
    }

    public int getDataType() {
        return 194;
    }

    public int getDataLength() {
        int dataSize = 4;
        Iterator iter = this.messageIterator();
        while (iter.hasNext()) {
            CalibrationEventMessage event = (CalibrationEventMessage)iter.next();
            dataSize += event.getDataLength() + 8;
        }
        return dataSize;
    }

    public void writeTo(byte[] buffer, int offset) {
        BigEndian.writeInt(buffer, offset, this.size());
        offset += 4;
        Iterator iter = this.messageIterator();
        while (iter.hasNext()) {
            CalibrationEventMessage event = (CalibrationEventMessage)iter.next();
            event.writeTo(buffer, offset);
            BigEndian.writeLong(buffer, offset += event.getDataLength(), this.getExpiry(event).getTime());
            offset += 8;
        }
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.clear();
        int nsize = BigEndian.readInt(buffer, offset);
        offset += 4;
        int i = 0;
        while (i < nsize) {
            CalibrationEventMessage entry = new CalibrationEventMessage(buffer, offset, length);
            Date expiry = new Date(BigEndian.readLong(buffer, offset += entry.getDataLength()));
            this.add(entry, expiry);
            offset += 8;
            ++i;
        }
    }

    public String toString() {
        return "CalibrationList (" + this.size() + " entries)";
    }
}

