/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.msg;

import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;

public class ChannelSet {
    static final int INT_SIZE = 4;
    static final int MIN_REQUEST_SIZE = 4;
    private int[] chnlKeys;

    public ChannelSet(int[] chnlKeys) {
        this.chnlKeys = new int[chnlKeys.length];
        System.arraycopy(chnlKeys, 0, this.chnlKeys, 0, chnlKeys.length);
    }

    public ChannelSet(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    public ChannelSet() {
        this.chnlKeys = new int[0];
    }

    public int getDataLength() {
        return 4 + 4 * this.chnlKeys.length;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        if (length < 4) throw new InvalidInputException("readFrom: insufficient data");
        int numChannels = BigEndian.readInt(buffer, offset);
        if (numChannels * 4 > length - 4) throw new InvalidInputException("readFrom: insufficient data");
        this.chnlKeys = new int[numChannels];
        int i = 0;
        while (i < numChannels) {
            this.chnlKeys[i] = BigEndian.readInt(buffer, offset + (i + 1) * 4);
            ++i;
        }
    }

    public void writeTo(byte[] buffer, int offset) {
        BigEndian.writeInt(buffer, offset, this.chnlKeys.length);
        int i = 0;
        while (i < this.chnlKeys.length) {
            BigEndian.writeInt(buffer, offset + (i + 1) * 4, this.chnlKeys[i]);
            ++i;
        }
    }

    public int[] getChannels() {
        return this.chnlKeys;
    }

    public int getChannelCount() {
        return this.chnlKeys.length;
    }
}

