/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.msg;

import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;

public class CommandRequest {
    public static final int LONG_SIZE = 8;
    public static final int INT_SIZE = 4;
    public static final int BYTE_SIZE = 1;
    public static final int CHAN_SIZE = 3;
    private String identifier;
    private String username;
    private String instrument;
    private String[] channels;

    public CommandRequest(String _identifier, String _username, String _instrument, String[] _channels) {
        this.identifier = _identifier;
        this.username = _username;
        this.instrument = _instrument;
        this.channels = _channels;
    }

    public CommandRequest(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    public int getDataLength() {
        int length = this.getIdentifierLength() + 1 + this.getUsernameLength() + 1 + this.getInstrumentLength() + 1 + 1 + this.channels.length * 3 + 1;
        return length;
    }

    public void writeTo(byte[] buffer, int offset) {
        int numChans;
        BigEndian.writeString(buffer, offset, this.identifier, buffer.length - offset);
        BigEndian.writeString(buffer, offset += this.getIdentifierLength() + 1, this.username, buffer.length - offset);
        BigEndian.writeString(buffer, offset += this.getUsernameLength() + 1, this.instrument, buffer.length - offset);
        buffer[offset += this.getInstrumentLength() + 1] = numChans = (int)this.getNumChannels();
        ++offset;
        int chani = 0;
        while (chani < numChans) {
            BigEndian.writeString(buffer, offset, this.getChannel(chani), 4);
            offset += 3;
            ++chani;
        }
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        int maxStringLength = buffer.length - offset;
        this.identifier = BigEndian.readString(buffer, offset, maxStringLength);
        maxStringLength = buffer.length - (offset += this.getIdentifierLength() + 1);
        this.username = BigEndian.readString(buffer, offset, maxStringLength);
        maxStringLength = buffer.length - (offset += this.getUsernameLength() + 1);
        this.instrument = BigEndian.readString(buffer, offset, maxStringLength);
        if (buffer.length - (offset += this.getInstrumentLength() + 1) < 1) {
            throw new InvalidInputException("readFrom: insufficient data.");
        }
        int numChans = buffer[offset];
        this.channels = new String[numChans];
        if (buffer.length - ++offset < 3 * numChans) {
            throw new InvalidInputException("readFrom: insufficient data.");
        }
        int chani = 0;
        while (chani < numChans) {
            this.channels[chani] = BigEndian.readString(buffer, offset, 3);
            offset += 3;
            ++chani;
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getUsername() {
        return this.username;
    }

    public String getInstrument() {
        return this.instrument;
    }

    public String getChannel(int chanIndex) {
        return this.channels[chanIndex];
    }

    public int getNumChannels() {
        return this.channels.length;
    }

    public String[] getChannels() {
        return this.channels;
    }

    public void setIdentifier(String newIdent) {
        this.identifier = newIdent;
    }

    public void setUsername(String newUser) {
        this.username = newUser;
    }

    public void setInstrument(String newInstr) {
        this.instrument = newInstr;
    }

    public void setChannel(String newChan, int chanIndex) {
        this.channels[chanIndex] = newChan;
    }

    public void setChannels(String[] newChans) {
        this.channels = newChans;
    }

    public String toString() {
        return "CommandRequest for instrument:" + this.getInstrument() + "by user: " + this.getUsername();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CommandRequest) {
            CommandRequest cr = (CommandRequest)obj;
            if (!this.getIdentifier().equalsIgnoreCase(cr.getIdentifier())) {
                return false;
            }
            if (!this.getUsername().equalsIgnoreCase(cr.getUsername())) {
                return false;
            }
            if (!this.getInstrument().equalsIgnoreCase(cr.getInstrument())) {
                return false;
            }
            if (this.getNumChannels() != cr.getNumChannels()) {
                return false;
            }
            int index = 0;
            while (index < this.getNumChannels()) {
                if (!this.getChannel(index).equalsIgnoreCase(cr.getChannel(index))) {
                    return false;
                }
                ++index;
            }
            return true;
        }
        return false;
    }

    private int getInstrumentLength() {
        int length = this.instrument.getBytes().length;
        return length;
    }

    private int getUsernameLength() {
        int length = this.username.getBytes().length;
        return length;
    }

    private int getIdentifierLength() {
        int length = this.identifier.getBytes().length;
        return length;
    }
}

