/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.msg;

import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;

public class CommandResult
implements Packable {
    public static final int MSG_TYPE = 193;
    private String identifier;
    private boolean[] valChannels;
    private String message;

    public CommandResult(String _message, boolean[] _valChannels, String _identifier) {
        this.message = _message;
        this.valChannels = _valChannels;
        this.identifier = _identifier;
    }

    public CommandResult(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    public int getDataType() {
        return 193;
    }

    public void writeTo(byte[] buffer, int offset) {
        int numChans;
        BigEndian.writeString(buffer, offset, this.identifier, buffer.length - offset);
        buffer[offset += this.getIdentifierLength() + 1] = numChans = (int)this.getNumChannels();
        ++offset;
        int chani = 0;
        while (chani < numChans) {
            buffer[offset] = this.valChannels[chani] ? (byte)1 : 0;
            ++offset;
            ++chani;
        }
        BigEndian.writeString(buffer, offset, this.message, buffer.length - offset);
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        int maxStringLength = buffer.length - offset;
        this.identifier = BigEndian.readString(buffer, offset, maxStringLength);
        if (buffer.length - (offset += this.getIdentifierLength() + 1) < 1) {
            throw new InvalidInputException("readFrom: insufficient data.");
        }
        int numChans = buffer[offset];
        this.valChannels = new boolean[numChans];
        if (buffer.length - ++offset < numChans) {
            throw new InvalidInputException("readFrom: insufficient data.");
        }
        int chani = 0;
        while (chani < numChans) {
            this.valChannels[chani] = buffer[offset] != 0;
            ++offset;
            ++chani;
        }
        maxStringLength = buffer.length - offset;
        this.message = BigEndian.readString(buffer, offset, maxStringLength);
    }

    public int getDataLength() {
        int dataLength = this.getIdentifierLength() + 1 + 1 + this.valChannels.length + this.getMessageLength() + 1;
        return dataLength;
    }

    public String getMessage() {
        return this.message;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean[] getValChannels() {
        return this.valChannels;
    }

    public int getNumChannels() {
        return this.valChannels.length;
    }

    public boolean getValChannel(int chanIndex) {
        return this.valChannels[chanIndex];
    }

    private int getIdentifierLength() {
        int length = this.identifier.getBytes().length;
        return length;
    }

    private int getMessageLength() {
        int length = this.message.getBytes().length;
        return length;
    }
}

