/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.msg;

import ca.nanometrics.msg.ChannelCommand;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;

public class MassCenterCommand
extends ChannelCommand
implements Packable {
    public static final int MSG_TYPE = 141;
    public static final int FLOAT_SIZE = 4;
    private float duration;

    public MassCenterCommand(int[] chnlKeys, String password, float dur) {
        super(chnlKeys, password);
        this.duration = dur;
    }

    public MassCenterCommand(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    public int getDataType() {
        return 141;
    }

    public int getDataLength() {
        return super.getDataLength() + 4;
    }

    public void writeTo(byte[] buffer, int offset) {
        super.writeTo(buffer, offset);
        BigEndian.writeFloat(buffer, offset += super.getDataLength(), this.duration);
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        super.readFrom(buffer, offset, length);
        if (buffer.length - (offset += super.getDataLength()) < 4) {
            throw new InvalidInputException("readFrom: insufficient data.");
        }
        this.duration = BigEndian.readFloat(buffer, offset);
    }

    public float getDuration() {
        return this.duration;
    }
}

