/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.msg;

import ca.nanometrics.packet.ChannelKey;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;

public class NmxpSequenceRequest
implements Packable {
    public static final int MSG_TYPE = 145;
    private static final int INT_SIZE = 4;
    private int key = 0;
    private int first = 0;
    private int last = 0;

    public NmxpSequenceRequest(int channelKey, int firstSeq, int lastSeq) {
        this.key = channelKey;
        this.first = firstSeq;
        this.last = lastSeq;
    }

    public NmxpSequenceRequest(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    public int getDataType() {
        return 145;
    }

    public int getDataLength() {
        return 12;
    }

    public void writeTo(byte[] buffer, int offset) {
        BigEndian.writeInt(buffer, offset, this.key);
        BigEndian.writeInt(buffer, offset += 4, this.first);
        BigEndian.writeInt(buffer, offset += 4, this.last);
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        if (buffer.length - offset < 12) {
            throw new InvalidInputException("readFrom: insufficient data.");
        }
        this.key = BigEndian.readInt(buffer, offset);
        this.first = BigEndian.readInt(buffer, offset += 4);
        this.last = BigEndian.readInt(buffer, offset += 4);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("NmxpSequenceRequest ");
        sb.append(ChannelKey.getKeyStringOf(this.getKey()));
        sb.append(" " + this.getFirst());
        sb.append("-" + this.getLast());
        return sb.toString();
    }

    public int getKey() {
        return this.key;
    }

    public int getFirst() {
        return this.first;
    }

    public int getLast() {
        return this.last;
    }
}

