/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.naqs.config;

import ca.nanometrics.naqs.config.AsciiSerialStream;
import ca.nanometrics.naqs.config.SerialOutStream;
import ca.nanometrics.naqs.config.Serialisable;
import ca.nanometrics.naqs.config.SerialiseException;
import java.util.Vector;

public class AsciiSerialOutStream
extends SerialOutStream
implements AsciiSerialStream {
    private StringBuffer outbuff = new StringBuffer();
    private Vector nameArray = new Vector(1000);
    private Vector objArray = new Vector(1000);
    private int objCount = 0;

    public AsciiSerialOutStream(int accessLevel) {
        super(accessLevel);
        this.writeAccessLevel();
    }

    public byte[] getBytes() {
        return this.outbuff.toString().getBytes();
    }

    private void writeAccessLevel() {
        this.outbuff.append("APL=");
        this.serialiseInt(this.getAccessLevel());
    }

    public void serialiseString(String value) {
        this.outbuff.append(value);
        this.outbuff.append(',');
    }

    public void serialiseInt(int value) {
        this.outbuff.append(value);
        this.outbuff.append(',');
    }

    public void serialiseLong(long value) {
        this.outbuff.append(value);
        this.outbuff.append(',');
    }

    public void serialiseFloat(float value) {
        this.outbuff.append(value);
        this.outbuff.append(',');
    }

    public void serialiseDouble(double value) {
        this.outbuff.append(value);
        this.outbuff.append(',');
    }

    public void serialiseChar(char value) {
        this.outbuff.append(value);
        this.outbuff.append(',');
    }

    public void serialiseBool(boolean value) {
        boolean outval = value;
        this.outbuff.append(value);
        this.outbuff.append(',');
    }

    private int lookup(Object obj, String name) {
        int i = 0;
        while (i < this.objCount) {
            if (this.objArray.elementAt(i) == obj && this.nameArray.elementAt(i).equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean isNewObject(Object obj, String name) {
        return this.lookup(obj, name) < 0;
    }

    public void serialiseObject(Serialisable obj) throws SerialiseException {
        if (obj == null) {
            throw new SerialiseException("Attempting to serialise null object.");
        }
        String name = obj.getClass().getName();
        int index = this.lookup(obj, name);
        if (!this.isNewObject(obj, name)) {
            throw new SerialiseException("Trying to serialise object twice: " + obj);
        }
        this.objArray.addElement(obj);
        this.nameArray.addElement(name);
        ++this.objCount;
        this.outbuff.append("\r\n");
        this.outbuff.append(name);
        this.outbuff.append('[');
        this.outbuff.append(this.objCount);
        this.outbuff.append(']');
        this.outbuff.append('{');
        obj.saveGuts(this);
        this.outbuff.append('}');
    }

    public void serialiseReference(Object obj) throws SerialiseException {
        String name;
        int index = -1;
        if (obj != null && (index = this.lookup(obj, name = obj.getClass().getName())) == -1) {
            throw new SerialiseException("Trying to serialise reference before object: " + name);
        }
        this.outbuff.append('(');
        this.outbuff.append(index + 1);
        this.outbuff.append(')');
        this.outbuff.append(',');
    }
}

