/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.naqs.config;

import ca.nanometrics.naqs.config.BoolConstraint;
import ca.nanometrics.naqs.config.SerialInStream;
import ca.nanometrics.naqs.config.SerialOutStream;

public class BoolEnum
extends BoolConstraint {
    private final int TRUE = 1;
    private final int FALSE = 0;
    String[] values = new String[2];
    char version = (char)48;

    public BoolEnum(String trueVal, String falseVal) {
        this.values[0] = falseVal;
        this.values[1] = trueVal;
    }

    public boolean valueOf(String str) {
        if (str.equalsIgnoreCase(this.values[1])) {
            return true;
        }
        if (str.equalsIgnoreCase(this.values[0])) {
            return false;
        }
        throw new IllegalArgumentException(str);
    }

    public boolean isGood(boolean value) {
        return true;
    }

    public String getDescription() {
        return new String("x = " + this.values[1] + " (T) or " + this.values[0] + " (F)");
    }

    public String getValueString(boolean val) {
        return val ? this.values[1] : this.values[0];
    }

    public void saveGuts(SerialOutStream strm) {
        strm.serialiseChar(this.version);
        strm.serialiseString(this.values[1]);
        strm.serialiseString(this.values[0]);
    }

    public void restoreGuts(SerialInStream strm) {
        char readVersion = strm.deserialiseChar();
        this.values[1] = strm.deserialiseString();
        this.values[0] = strm.deserialiseString();
    }

    public String getClassName() {
        return "BoolEnum";
    }
}

