/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.naqs.config;

import ca.nanometrics.naqs.config.DoubleConstraint;
import ca.nanometrics.naqs.config.SerialInStream;
import ca.nanometrics.naqs.config.SerialOutStream;

public class DoubleRange
extends DoubleConstraint {
    double max;
    double min;
    char version = (char)48;

    public DoubleRange(double newmin, double newmax) {
        this.max = newmax;
        this.min = newmin;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public String getDescription() {
        return new String(String.valueOf(this.min) + " <= x <= " + this.max);
    }

    public boolean isGood(double val) {
        return val <= this.max && val >= this.min;
    }

    public void saveGuts(SerialOutStream strm) {
        strm.serialiseChar(this.version);
        strm.serialiseDouble(this.min);
        strm.serialiseDouble(this.max);
    }

    public void restoreGuts(SerialInStream strm) {
        char readVersion = strm.deserialiseChar();
        this.min = strm.deserialiseDouble();
        this.max = strm.deserialiseDouble();
    }
}

