/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.naqs.config;

import ca.nanometrics.naqs.config.FloatConstraint;
import ca.nanometrics.naqs.config.SerialInStream;
import ca.nanometrics.naqs.config.SerialOutStream;

public class FloatRange
extends FloatConstraint {
    float max;
    float min;
    char version = (char)48;

    public FloatRange(float newmin, float newmax) {
        this.max = newmax;
        this.min = newmin;
    }

    public float getMax() {
        return this.max;
    }

    public float getMin() {
        return this.min;
    }

    public String getDescription() {
        return new String(String.valueOf(this.min) + " <= x <= " + this.max);
    }

    public boolean isGood(float val) {
        return val <= this.max && val >= this.min;
    }

    public void saveGuts(SerialOutStream strm) {
        strm.serialiseChar(this.version);
        strm.serialiseFloat(this.min);
        strm.serialiseFloat(this.max);
    }

    public void restoreGuts(SerialInStream strm) {
        char readVersion = strm.deserialiseChar();
        this.min = strm.deserialiseFloat();
        this.max = strm.deserialiseFloat();
    }
}

