/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.naqs.config;

import ca.nanometrics.naqs.config.IntConstraint;
import ca.nanometrics.naqs.config.Param;
import ca.nanometrics.naqs.config.SerialInStream;
import ca.nanometrics.naqs.config.SerialOutStream;
import ca.nanometrics.naqs.config.SerialiseException;
import ca.nanometrics.naqs.config.UpdateException;
import ca.nanometrics.naqs.config.UpdateMode;

public class IntParam
extends Param {
    int value = 0;
    char version = (char)48;
    private IntConstraint constraint;

    public IntParam(String aLabel, int newValue, int newattrib, IntConstraint newConstraint) {
        super(aLabel, newattrib);
        this.constraint = newConstraint;
        this.putValue(newValue);
    }

    public int getValue() {
        return this.value;
    }

    public String getValueString() {
        if (this.constraint != null) {
            return this.constraint.getValueString(this.getValue());
        }
        return Integer.toString(this.getValue());
    }

    void validate(int newValue) throws UpdateException {
        if (this.constraint != null && !this.constraint.isGood(newValue)) {
            throw this.BadValue(Integer.toString(newValue), this.constraint);
        }
    }

    public void putValue(int newValue) throws UpdateException {
        this.validate(newValue);
        this.value = newValue;
    }

    public void putValue(int newValue, UpdateMode mode) throws UpdateException {
        if (this.value != newValue) {
            if (this.haveWritePermission(mode.getWho())) {
                this.validate(newValue);
                if (!mode.isTest()) {
                    this.value = newValue;
                }
            } else {
                throw this.NoPermission();
            }
        }
    }

    public int valueOf(String str) throws UpdateException {
        try {
            if (this.constraint != null) {
                return this.constraint.valueOf(str);
            }
            return Integer.parseInt(str);
        }
        catch (IllegalArgumentException iae) {
            throw this.FormatError(str);
        }
    }

    public void putValue(String str) throws UpdateException {
        int newValue = this.valueOf(str);
        this.putValue(newValue);
    }

    public void putValue(String str, UpdateMode mode) throws UpdateException {
        int newValue = this.valueOf(str);
        this.putValue(newValue, mode);
    }

    public void saveGuts(SerialOutStream strm) throws SerialiseException {
        super.saveGuts(strm);
        strm.serialiseChar(this.version);
        strm.serialiseInt(this.value);
        strm.serialiseReference(this.constraint);
    }

    public void restoreGuts(SerialInStream strm) throws SerialiseException {
        super.restoreGuts(strm);
        char readVersion = strm.deserialiseChar();
        this.value = strm.deserialiseInt();
        this.constraint = (IntConstraint)strm.deserialiseReference();
    }
}

