/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.naqs.config;

import ca.nanometrics.naqs.config.IntConstraint;
import ca.nanometrics.naqs.config.SerialInStream;
import ca.nanometrics.naqs.config.SerialOutStream;

public class IntRange
extends IntConstraint {
    int max;
    int min;
    char version = (char)48;

    public IntRange(int newmin, int newmax) {
        this.max = newmax;
        this.min = newmin;
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    public String getDescription() {
        return new String(String.valueOf(this.min) + " <= x <= " + this.max);
    }

    public boolean isGood(int val) {
        return val <= this.max && val >= this.min;
    }

    public void saveGuts(SerialOutStream strm) {
        strm.serialiseChar(this.version);
        strm.serialiseInt(this.min);
        strm.serialiseInt(this.max);
    }

    public void restoreGuts(SerialInStream strm) {
        char readVersion = strm.deserialiseChar();
        this.min = strm.deserialiseInt();
        this.max = strm.deserialiseInt();
    }
}

