/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.naqs.config;

import ca.nanometrics.naqs.config.Constraint;
import ca.nanometrics.naqs.config.SerialInStream;
import ca.nanometrics.naqs.config.SerialOutStream;
import ca.nanometrics.naqs.config.Serialisable;
import ca.nanometrics.naqs.config.SerialiseException;
import ca.nanometrics.naqs.config.UpdateException;
import ca.nanometrics.naqs.config.UpdateMode;

public abstract class Param
implements Serialisable {
    public static final int WRITEMASK = 56;
    public static final int READMASK = 3;
    public static final int NOBODY = 0;
    public static final int USER = 1;
    public static final int TECH = 2;
    public static final int FACTORY = 3;
    public static final int WUSER = 8;
    public static final int WTECH = 16;
    public static final int WFACTORY = 24;
    public static final int WNEVER = 32;
    public static final int WNOTYET = 40;
    private char version = (char)48;
    private String label;
    private int attrib;

    protected Param(String label, int attrib) {
        this.attrib = attrib;
        this.label = label;
    }

    public int getAttrib() {
        return this.attrib;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean haveWritePermission(int whoIs) {
        return whoIs >= (this.attrib & 0x38) >> 3;
    }

    public boolean haveReadPermission(int whoIs) {
        return whoIs >= (this.attrib & 3);
    }

    public void showAttribs() {
        System.out.print("Permission: ");
        switch (this.getAttrib() & 3) {
            case 1: {
                System.out.print("USER   ");
                break;
            }
            case 2: {
                System.out.print("TECH   ");
                break;
            }
            case 3: {
                System.out.print("FACTORY");
                break;
            }
            default: {
                System.out.print("Unknown");
            }
        }
        switch (this.getAttrib() & 0x38) {
            case 8: {
                System.out.println(" | WUSER");
                break;
            }
            case 16: {
                System.out.println(" | WTECH");
                break;
            }
            case 24: {
                System.out.println(" | WFACTORY");
                break;
            }
            case 32: {
                System.out.println(" | WNEVER");
                break;
            }
            case 40: {
                System.out.println(" | WNOTYET");
                break;
            }
            default: {
                System.out.println(" | Unknown");
            }
        }
    }

    public abstract String getValueString();

    public abstract void putValue(String var1) throws UpdateException;

    public abstract void putValue(String var1, UpdateMode var2) throws UpdateException;

    protected UpdateException NoPermission() {
        return new UpdateException(String.valueOf(this.getLabel()) + ": no write permission");
    }

    protected UpdateException BadValue(String val, Constraint constraint) {
        return new UpdateException(String.valueOf(this.getLabel()) + ": " + val + " violates constraint " + constraint.getDescription());
    }

    protected UpdateException FormatError(String val) {
        return new UpdateException(String.valueOf(this.getLabel()) + ": " + val + " has format error");
    }

    public void saveGuts(SerialOutStream strm) throws SerialiseException {
        strm.serialiseChar(this.version);
        strm.serialiseString(this.label);
        strm.serialiseInt(this.attrib);
    }

    public void restoreGuts(SerialInStream strm) throws SerialiseException {
        char readVersion = strm.deserialiseChar();
        this.label = strm.deserialiseString();
        this.attrib = strm.deserialiseInt();
    }
}

