/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.naqs.config;

import ca.nanometrics.naqs.config.Param;
import ca.nanometrics.naqs.config.SerialInStream;
import ca.nanometrics.naqs.config.SerialOutStream;
import ca.nanometrics.naqs.config.SerialiseException;
import ca.nanometrics.naqs.config.StringConstraint;
import ca.nanometrics.naqs.config.UpdateException;
import ca.nanometrics.naqs.config.UpdateMode;

public class StringParam
extends Param {
    String value = "";
    char version = (char)48;
    private StringConstraint constraint;

    public StringParam(String aLabel, String newValue, int newattrib, StringConstraint newConstraint) {
        super(aLabel, newattrib);
        this.constraint = newConstraint;
        this.putValue(newValue);
    }

    public String getValue() {
        return this.value;
    }

    public String getValueString() {
        if (this.constraint != null) {
            return this.constraint.getValueString(this.getValue());
        }
        return this.getValue();
    }

    void validate(String newValue) throws UpdateException {
        if (this.constraint != null && !this.constraint.isGood(newValue)) {
            throw this.BadValue(newValue, this.constraint);
        }
    }

    public void putValue(String newValue) throws UpdateException {
        this.validate(newValue);
        this.value = newValue;
    }

    public void putValue(String newValue, UpdateMode mode) throws UpdateException {
        if (!this.value.equals(newValue)) {
            if (this.haveWritePermission(mode.getWho())) {
                this.validate(newValue);
                if (!mode.isTest()) {
                    this.value = newValue;
                }
            } else {
                throw this.NoPermission();
            }
        }
    }

    public void saveGuts(SerialOutStream strm) throws SerialiseException {
        super.saveGuts(strm);
        strm.serialiseChar(this.version);
        strm.serialiseString(this.value);
        strm.serialiseReference(this.constraint);
    }

    public void restoreGuts(SerialInStream strm) throws SerialiseException {
        super.restoreGuts(strm);
        char readVersion = strm.deserialiseChar();
        this.value = strm.deserialiseString();
        this.constraint = (StringConstraint)strm.deserialiseReference();
    }
}

