/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.naqs.stndb;

import ca.nanometrics.naqs.stndb.SensorConfig;
import java.io.IOException;

public class ChannelPrototype {
    static final int NAME_LENGTH = 3;
    private SensorConfig sensor;
    private String typeName;
    private String channelName;
    private int component;
    private double azimuth;
    private double dip;
    private double depth;
    private int bundlesPerPacket;
    private int ringBufferSize;
    private String ringBufferPath;
    private String responseFile;

    public ChannelPrototype(String theTypeName, String theChannelName, int theComponent, SensorConfig theSensor, double theAzimuth, double theDip, double theDepth, int theBundlesPerPacket, int theRingBufferSize, String theRingBufferPath, String theResponseFile) throws IOException {
        this.typeName = theTypeName;
        this.channelName = theChannelName;
        this.component = theComponent;
        this.sensor = theSensor;
        this.azimuth = theAzimuth;
        this.dip = theDip;
        this.depth = theDepth;
        this.bundlesPerPacket = theBundlesPerPacket;
        this.ringBufferSize = theRingBufferSize;
        this.ringBufferPath = theRingBufferPath;
        this.responseFile = theResponseFile;
        this.validate();
    }

    private void validate() throws IOException {
        if (this.sensor == null) {
            throw new IOException("null sensor in ChannelPrototype");
        }
        if (this.channelName.length() > 3) {
            this.channelName = this.channelName.substring(0, 3);
        }
    }

    public SensorConfig getSensor() {
        return this.sensor;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public int getComponent() {
        return this.component;
    }

    public double getAzimuth() {
        return this.azimuth;
    }

    public double getDip() {
        return this.dip;
    }

    public double getDepth() {
        return this.depth;
    }

    public int getBundlesPerPacket() {
        return this.bundlesPerPacket;
    }

    public int getRingBufferSize() {
        return this.ringBufferSize;
    }

    public String getRingBufferPath() {
        return this.ringBufferPath;
    }

    public String getResponseFile() {
        return this.responseFile;
    }
}

