/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.naqs.stndb;

import ca.nanometrics.naqs.stndb.BaseChannelConfig;
import ca.nanometrics.naqs.stndb.ChannelPrototype;
import ca.nanometrics.naqs.stndb.InstrumentConfig;
import ca.nanometrics.naqs.stndb.SensorConfig;
import ca.nanometrics.naqs.stndb.StationConfig;
import ca.nanometrics.packet.NmxPacket;
import java.io.IOException;

public class DataChannelConfig
extends BaseChannelConfig {
    static final int MAX_ENABLE = 3;
    static final int MAX_RELAY = 6;
    ChannelPrototype prototype;
    Double azimuth = null;
    Double dip = null;
    Double depth = null;
    Integer ringBufferSize = null;
    String ringBufferPath = null;
    String responseFile = null;
    Double sensitivity = null;
    Double sensitivityFreq = null;
    Double calCoilResistance = null;
    Double calCoilConstant = null;

    public DataChannelConfig(StationConfig theStation, InstrumentConfig theInstrument, ChannelPrototype thePrototype) throws IOException {
        super(theStation, theInstrument);
        this.prototype = thePrototype;
        this.validate();
    }

    private void validate() throws IOException {
        if (this.prototype == null) {
            throw new IOException("null prototype in DataChannelConfig");
        }
    }

    public String getChannelName() {
        return this.prototype.getChannelName();
    }

    public int getChannel() {
        return this.prototype.getComponent();
    }

    public int getBundlesPerPacket() {
        return this.prototype.getBundlesPerPacket();
    }

    public int getPacketLength() {
        return 17 * (1 + this.getBundlesPerPacket());
    }

    public int getType() {
        return 1;
    }

    public int getFileTag() {
        return 43;
    }

    public double getAzimuth() {
        if (this.azimuth != null) {
            return this.azimuth;
        }
        return this.prototype.getAzimuth();
    }

    public double getDip() {
        if (this.dip != null) {
            return this.dip;
        }
        return this.prototype.getDip();
    }

    public double getDepth() {
        if (this.depth != null) {
            return this.depth;
        }
        return this.prototype.getDepth();
    }

    public int getRingBufferSize() {
        if (this.ringBufferSize != null) {
            return this.ringBufferSize;
        }
        return this.prototype.getRingBufferSize();
    }

    public String getRingBufferPath() {
        if (this.ringBufferPath != null) {
            return this.ringBufferPath;
        }
        return this.prototype.getRingBufferPath();
    }

    public String getResponseFile() {
        if (this.responseFile != null) {
            return this.responseFile;
        }
        return this.prototype.getResponseFile();
    }

    private SensorConfig getSensor() {
        return this.prototype.getSensor();
    }

    public String getSensorType() {
        return this.getSensor().getModel();
    }

    public String getSensitivityUnits() {
        return this.getSensor().getSensitivityUnits();
    }

    public String getCalibrationUnits() {
        return this.getSensor().getCalibrationUnits();
    }

    public int getCalibrationSource() {
        return this.getSensor().getCalibrationSource();
    }

    private int getChannelValOf(int sensorVal, int maxVal) {
        int channel = this.getChannel();
        if (sensorVal == 0 && channel <= maxVal) {
            return channel;
        }
        if (sensorVal >= 0 && sensorVal <= maxVal) {
            return sensorVal;
        }
        return 0;
    }

    private int getChannelRelayValOf(int sensorVal, int maxVal) {
        int channel = this.getChannel();
        if (sensorVal == 8 && channel <= maxVal) {
            return channel + 8;
        }
        return this.getChannelValOf(sensorVal, maxVal);
    }

    public int getCalEnable() {
        int sensorVal = this.getSensor().getCalEnable();
        return this.getChannelValOf(sensorVal, 3);
    }

    public int getCalRelay() {
        int sensorVal = this.getSensor().getCalRelay();
        return this.getChannelRelayValOf(sensorVal, 6);
    }

    public int getMassCenterEnable() {
        int sensorVal = this.getSensor().getMassCenterEnable();
        return this.getChannelValOf(sensorVal, 3);
    }

    public double getMassCenterDuration() {
        return this.getSensor().getMassCenterDuration();
    }

    public double getSensitivity() {
        if (this.sensitivity != null) {
            return this.sensitivity;
        }
        return this.getSensor().getSensitivity();
    }

    public double getSensitivityFreq() {
        if (this.sensitivityFreq != null) {
            return this.sensitivityFreq;
        }
        return this.getSensor().getSensitivityFreq();
    }

    public double getCalCoilResistance() {
        if (this.calCoilResistance != null) {
            return this.calCoilResistance;
        }
        return this.getSensor().getCalCoilResistance();
    }

    public double getCalCoilConstant() {
        if (this.calCoilConstant != null) {
            return this.calCoilConstant;
        }
        return this.getSensor().getCalCoilConstant();
    }

    public String getFormat() {
        return "X";
    }

    public int getKey() {
        return NmxPacket.getKeyOf(1, this.getChannel() - 1, this.getInstrumentID());
    }

    public void setAzimuth(double val) {
        this.azimuth = new Double(val);
    }

    public void setDip(double val) {
        this.dip = new Double(val);
    }

    public void setDepth(double val) {
        this.depth = new Double(val);
    }

    public void setRingBufferSize(int val) {
        this.ringBufferSize = new Integer(val);
    }

    public void setRingBufferPath(String name) {
        this.ringBufferPath = name;
    }

    public void setResponseFile(String name) {
        this.responseFile = name;
    }

    public void setSensitivity(double val) {
        this.sensitivity = new Double(val);
    }

    public void setSensitivityFreq(double val) {
        this.sensitivityFreq = new Double(val);
    }

    public void setCalCoilResistance(double val) {
        this.calCoilResistance = new Double(val);
    }

    public void setCalCoilConstant(double val) {
        this.calCoilConstant = new Double(val);
    }
}

