/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.naqs.stndb;

import ca.nanometrics.naqs.stndb.DetectorType;
import java.util.Enumeration;
import java.util.Hashtable;

public class DetectorTable {
    private Hashtable table = new Hashtable();

    private String keyOf(String name) {
        return name.toUpperCase();
    }

    public DetectorType add(DetectorType detector) {
        String name = detector.getName();
        return this.table.put(this.keyOf(name), detector);
    }

    public boolean contains(DetectorType detector) {
        String name = detector.getName();
        int type = detector.getType();
        return this.contains(name) || this.contains(type);
    }

    public boolean contains(String name) {
        return this.table.containsKey(this.keyOf(name));
    }

    public DetectorType get(String name) {
        return (DetectorType)this.table.get(this.keyOf(name));
    }

    public DetectorType remove(String name) {
        return (DetectorType)this.table.remove(this.keyOf(name));
    }

    public boolean contains(int type) {
        return this.get(type) != null;
    }

    public DetectorType get(int type) {
        Enumeration e = this.table.elements();
        while (e.hasMoreElements()) {
            DetectorType detector = (DetectorType)e.nextElement();
            if (detector.getType() != type) continue;
            return detector;
        }
        return null;
    }

    public DetectorType remove(int type) {
        DetectorType detector = this.get(type);
        if (detector != null) {
            this.table.remove(this.keyOf(detector.getName()));
        }
        return detector;
    }

    public Enumeration elements() {
        return this.table.elements();
    }

    public int size() {
        return this.table.size();
    }
}

