/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.naqs.stndb;

import ca.nanometrics.packet.Instrument;
import java.io.IOException;

public class InstrumentPrototype {
    static final int NAME_LENGTH = 3;
    private String typeName;
    private String model;
    private int type;
    private int memoryKb;
    private int bundlesPerPacket;
    private int requestInterval;
    private String sohChannelName;
    private int sohBufferSize;
    private String sohBufferPath;
    private String inetHostName;
    private int inetPort;

    public InstrumentPrototype(String theTypeName, String theModel, int theMemoryKb, int theBundlesPerPacket, int theRequestInterval, String theSohChannelName, int theSohBufferSize, String theSohBufferPath, String theInetHostName, int theInetPort) throws IOException {
        this.type = Instrument.getModelOf(theModel);
        if (this.type < 0) {
            throw new IOException("Invalid instrument model: " + theModel);
        }
        this.typeName = theTypeName;
        this.model = Instrument.getModelNameOf(this.type);
        this.memoryKb = theMemoryKb;
        this.bundlesPerPacket = theBundlesPerPacket;
        this.requestInterval = theRequestInterval;
        this.sohChannelName = theSohChannelName;
        this.sohBufferSize = theSohBufferSize;
        this.sohBufferPath = theSohBufferPath;
        this.inetHostName = theInetHostName;
        this.inetPort = theInetPort;
    }

    private void validate() throws IOException {
        if (this.sohChannelName.length() > 3) {
            this.sohChannelName = this.sohChannelName.substring(0, 3);
        }
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getType() {
        return this.type;
    }

    public String getModel() {
        return this.model;
    }

    public int getMemoryKb() {
        return this.memoryKb;
    }

    public int getBundlesPerPacket() {
        return this.bundlesPerPacket;
    }

    public int getRequestInterval() {
        return this.requestInterval;
    }

    public String getSohChannelName() {
        return this.sohChannelName;
    }

    public int getSohBufferSize() {
        return this.sohBufferSize;
    }

    public String getSohBufferPath() {
        return this.sohBufferPath;
    }

    public String getInetHostName() {
        return this.inetHostName;
    }

    public int getInetPort() {
        return this.inetPort;
    }
}

