/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.naqs.stndb;

import ca.nanometrics.naqs.stndb.BaseChannelConfig;
import ca.nanometrics.naqs.stndb.InstrumentConfig;
import ca.nanometrics.naqs.stndb.StationConfig;
import ca.nanometrics.packet.NmxPacket;
import java.io.IOException;

public class SohChannelConfig
extends BaseChannelConfig {
    public SohChannelConfig(StationConfig theStation, InstrumentConfig theInstrument) throws IOException {
        super(theStation, theInstrument);
    }

    public int getChannel() {
        return 0;
    }

    public int getType() {
        return 2;
    }

    public int getFileTag() {
        return 44;
    }

    public double getAzimuth() {
        return 0.0;
    }

    public double getDip() {
        return 0.0;
    }

    public double getDepth() {
        return 0.0;
    }

    public String getChannelName() {
        return this.instrument.getSohChannelName();
    }

    public int getRingBufferSize() {
        return this.instrument.getSohBufferSize();
    }

    public String getRingBufferPath() {
        return this.instrument.getSohBufferPath();
    }

    public String getResponseFile() {
        return "";
    }

    public int getBundlesPerPacket() {
        return this.instrument.getBundlesPerPacket();
    }

    public int getPacketLength() {
        return 17 * (1 + this.getBundlesPerPacket());
    }

    public String getSensorType() {
        return "SOH";
    }

    public String getSensitivityUnits() {
        return "NONE";
    }

    public String getCalibrationUnits() {
        return "NONE";
    }

    public int getCalEnable() {
        return 0;
    }

    public int getCalRelay() {
        return 0;
    }

    public int getMassCenterEnable() {
        return 0;
    }

    public double getMassCenterDuration() {
        return 1.0;
    }

    public int getCalibrationSource() {
        return 0;
    }

    public double getSensitivity() {
        return 1.0;
    }

    public double getSensitivityFreq() {
        return 1.0;
    }

    public double getCalCoilResistance() {
        return 1.0;
    }

    public double getCalCoilConstant() {
        return 1.0;
    }

    public String getFormat() {
        return "U";
    }

    public int getAppendSize() {
        return 0;
    }

    public int getKey() {
        return NmxPacket.getKeyOf(this.getType(), 0, this.getInstrumentID());
    }
}

