/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.nda;

import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;

public class ConnectRequest
implements Packable {
    public static final int MSG_TYPE = 206;
    public static final int INT_SIZE = 4;
    static final int NAME_LEN = 12;
    static final int MAX_LENGTH = 11;
    static final int MSG_LEN = 24;
    private int protocolVersion;
    private int messageTime;
    private String username;
    private int crc;

    public ConnectRequest(String user, String password, int version, int timeSec) {
        this.protocolVersion = version;
        this.messageTime = timeSec;
        this.username = user;
        if (this.username == null) {
            this.username = "any";
        }
        if (this.username.length() > 11) {
            this.username = this.username.substring(0, 11);
        }
        if (password == null) {
            password = "none";
        }
        this.crc = this.getCrc(password);
    }

    public ConnectRequest(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    public int getDataType() {
        return 206;
    }

    public int getDataLength() {
        return 24;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public int getMessageTime() {
        return this.messageTime;
    }

    public int getCrc() {
        return this.crc;
    }

    protected int getCrc(String password) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.write(this.username.getBytes());
            dos.writeInt(this.protocolVersion);
            dos.writeInt(this.messageTime);
            dos.write(password.getBytes());
            CRC32 engine = new CRC32();
            engine.update(baos.toByteArray());
            return (int)engine.getValue();
        }
        catch (IOException ioe) {
            return 0;
        }
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isValidCrc(String password) {
        return this.crc == this.getCrc(password);
    }

    public boolean isTimely(int limit) {
        int now = (int)(System.currentTimeMillis() / 1000L);
        return Math.abs(this.messageTime - now) <= limit;
    }

    public boolean isValid(String password, int limit) {
        return this.isTimely(limit) && this.isValidCrc(password);
    }

    public boolean isValid(String password) {
        return this.isValid(password, 1800);
    }

    public void writeTo(byte[] buffer, int offset) {
        BigEndian.writeString(buffer, offset, this.username, 12);
        BigEndian.writeInt(buffer, offset += 12, this.protocolVersion);
        BigEndian.writeInt(buffer, offset += 4, this.messageTime);
        BigEndian.writeInt(buffer, offset += 4, this.crc);
        offset += 4;
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        if (length >= 24 && offset + 24 <= buffer.length) {
            this.username = BigEndian.readString(buffer, offset, 12);
            this.protocolVersion = BigEndian.readInt(buffer, offset += 12);
            this.messageTime = BigEndian.readInt(buffer, offset += 4);
            this.crc = BigEndian.readInt(buffer, offset += 4);
            offset += 4;
        } else {
            throw new InvalidInputException("readFrom: insufficient data");
        }
    }

    public String toString() {
        String className = this.getClass().getName();
        return String.valueOf(className) + " " + this.username + " " + this.protocolVersion + " (" + this.messageTime + ", " + this.crc + ")";
    }
}

