/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.nda;

import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;

public class EventRequest
implements Packable {
    public static final int MSG_TYPE = 232;
    public static final int INT_SIZE = 4;
    public static final int DOUBLE_SIZE = 8;
    public static final int MSG_LEN = 16;
    private int startTime;
    private int endTime;
    private double amplitude;

    public EventRequest() {
        this(0, 0, 0.0);
    }

    public EventRequest(int startSec, int endSec, double minAmp) {
        this.startTime = startSec;
        this.endTime = endSec;
        this.amplitude = minAmp;
    }

    public EventRequest(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    public int getDataType() {
        return 232;
    }

    public int getDataLength() {
        return 16;
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        if (length < 16 || offset + 16 > buffer.length) {
            throw new InvalidInputException("readFrom: insufficient data");
        }
        this.startTime = BigEndian.readInt(buffer, offset);
        this.endTime = BigEndian.readInt(buffer, offset += 4);
        this.amplitude = BigEndian.readDouble(buffer, offset += 4);
    }

    public void writeTo(byte[] buffer, int offset) {
        BigEndian.writeInt(buffer, offset, this.startTime);
        BigEndian.writeInt(buffer, offset += 4, this.endTime);
        BigEndian.writeDouble(buffer, offset += 4, this.amplitude);
    }

    public int getStartTime() {
        return this.startTime;
    }

    public int getEndTime() {
        return this.endTime;
    }

    public double getAmplitude() {
        return this.amplitude;
    }

    public String toString() {
        String className = this.getClass().getName();
        return String.valueOf(className) + " (" + this.startTime + ", " + this.endTime + ", " + this.amplitude + ")";
    }
}

