/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.nda;

import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;

public abstract class IntervalRequest
implements Packable {
    public static final int INT_SIZE = 4;
    public static final int MSG_LEN = 12;
    private int key;
    private int startTime;
    private int endTime;

    public IntervalRequest() {
        this(0, 0, 0);
    }

    public IntervalRequest(int channelKey, int startSec, int endSec) {
        this.key = channelKey;
        this.startTime = startSec;
        this.endTime = endSec;
    }

    public IntervalRequest(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    public int getDataLength() {
        return 12;
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        if (length < 12 || offset + length > buffer.length) {
            throw new InvalidInputException("readFrom: insufficient data");
        }
        this.key = BigEndian.readInt(buffer, offset);
        this.startTime = BigEndian.readInt(buffer, offset + 4);
        this.endTime = BigEndian.readInt(buffer, offset + 8);
    }

    public void writeTo(byte[] buffer, int offset) {
        BigEndian.writeInt(buffer, offset, this.key);
        BigEndian.writeInt(buffer, offset + 4, this.startTime);
        BigEndian.writeInt(buffer, offset + 8, this.endTime);
    }

    public int getKey() {
        return this.key;
    }

    public int getStartTime() {
        return this.startTime;
    }

    public int getEndTime() {
        return this.endTime;
    }

    protected String toStringEx() {
        return "";
    }

    public String toString() {
        String className = this.getClass().getName();
        return String.valueOf(className) + " " + this.key + " (" + this.startTime + ", " + this.endTime + this.toStringEx() + ")";
    }
}

