/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.nda;

import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;

public class NaqsEvent
implements Packable {
    public static final int MSG_TYPE = 260;
    static final int DOUBLE_SIZE = 8;
    static final int MSG_LEN = 24;
    private double eventTime;
    private double duration;
    private double amplitude;

    public NaqsEvent() {
        this(0.0, 0.0, 0.0);
    }

    public NaqsEvent(double eTime, double eDuration, double eSize) {
        this.eventTime = eTime;
        this.duration = eDuration;
        this.amplitude = eSize;
    }

    public NaqsEvent(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    public double getEventTime() {
        return this.eventTime;
    }

    public double getDuration() {
        return this.duration;
    }

    public double getAmplitude() {
        return this.amplitude;
    }

    public int getDataLength() {
        return 24;
    }

    public int getDataType() {
        return 260;
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        if (length < 24 || offset + 24 > buffer.length) {
            throw new InvalidInputException("readFrom: insufficient data");
        }
        this.eventTime = BigEndian.readDouble(buffer, offset);
        this.duration = BigEndian.readDouble(buffer, offset += 8);
        this.amplitude = BigEndian.readDouble(buffer, offset += 8);
    }

    public void writeTo(byte[] buffer, int offset) {
        BigEndian.writeDouble(buffer, offset, this.eventTime);
        BigEndian.writeDouble(buffer, offset += 8, this.duration);
        BigEndian.writeDouble(buffer, offset += 8, this.amplitude);
    }

    public String toString() {
        String className = this.getClass().getName();
        return String.valueOf(className) + " (" + this.eventTime + ", " + this.duration + ", " + this.amplitude + ")";
    }
}

