/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.nda;

import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;

public class NaqsTrigger
implements Packable {
    public static final int MSG_TYPE = 259;
    static final int NAME_LEN = 12;
    static final int INT_SIZE = 4;
    static final int DOUBLE_SIZE = 8;
    static final int MAX_LENGTH = 11;
    static final int MSG_LEN = 32;
    private int key;
    private String name;
    private double triggerTime;
    private double duration;

    public NaqsTrigger() {
        this(0, null, 0.0, 0.0);
    }

    public NaqsTrigger(int channelKey, String channelName, double trigTime, double trigDur) {
        this.key = channelKey;
        this.name = channelName;
        this.triggerTime = trigTime;
        this.duration = trigDur;
        if (this.name == null) {
            this.name = "none";
        }
        if (this.name.length() > 11) {
            this.name = this.name.substring(0, 11);
        }
    }

    public NaqsTrigger(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    public int getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public double getTriggerTime() {
        return this.triggerTime;
    }

    public double getDuration() {
        return this.duration;
    }

    public int getDataLength() {
        return 32;
    }

    public int getDataType() {
        return 259;
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        if (length >= 32 && offset + 32 <= buffer.length) {
            this.key = BigEndian.readInt(buffer, offset);
            this.name = BigEndian.readString(buffer, offset += 4, 12);
            this.triggerTime = BigEndian.readDouble(buffer, offset += 12);
            this.duration = BigEndian.readDouble(buffer, offset += 8);
            offset += 8;
        } else {
            throw new InvalidInputException("readFrom: insufficient data");
        }
    }

    public void writeTo(byte[] buffer, int offset) {
        BigEndian.writeInt(buffer, offset, this.key);
        BigEndian.writeString(buffer, offset += 4, this.name, 12);
        BigEndian.writeDouble(buffer, offset += 12, this.triggerTime);
        BigEndian.writeDouble(buffer, offset += 8, this.duration);
        offset += 8;
    }

    public String toString() {
        String className = this.getClass().getName();
        return String.valueOf(className) + " " + this.name + " " + this.key + " (" + this.triggerTime + ", " + this.duration + ")";
    }
}

