/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.nda;

import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ResponseFileMsg
implements Packable {
    public static final int MSG_TYPE = 262;
    static final int INT_SIZE = 4;
    private int key;
    private byte[] response;

    public ResponseFileMsg(int channelKey, byte[] responseData) {
        this.key = channelKey;
        if (responseData == null) {
            responseData = new byte[]{};
        } else {
            this.response = responseData;
        }
    }

    public ResponseFileMsg() {
        this(0, null);
    }

    public ResponseFileMsg(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    public int getKey() {
        return this.key;
    }

    public byte[] getResponse() {
        return this.response;
    }

    public InputStream getResponseStream() {
        return new ByteArrayInputStream(this.response);
    }

    public int getDataLength() {
        return 4 + this.response.length;
    }

    public int getDataType() {
        return 262;
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        if (length < 4 || offset + length > buffer.length) {
            throw new InvalidInputException("readFrom: insufficient data");
        }
        this.key = BigEndian.readInt(buffer, offset);
        this.response = new byte[length -= 4];
        System.arraycopy(buffer, offset += 4, this.response, 0, length);
    }

    public void writeTo(byte[] buffer, int offset) {
        BigEndian.writeInt(buffer, offset, this.key);
        System.arraycopy(this.response, 0, buffer, offset += 4, this.response.length);
    }

    public String toString() {
        String className = this.getClass().getName();
        return String.valueOf(className) + " (" + this.key + ")";
    }
}

