/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

public class ConnectTimer
implements Runnable {
    private InetAddress address;
    private int port;
    private int timeout;
    private Socket socket = null;
    private IOException ioe = null;
    private Exception exc = null;

    private ConnectTimer(InetAddress hostAddress, int hostPort, int timeoutMillis) {
        this.address = hostAddress;
        this.port = hostPort;
        this.timeout = Math.max(timeoutMillis, 100);
    }

    private synchronized Socket open() throws IOException {
        Thread t = new Thread(this);
        t.setDaemon(true);
        t.start();
        try {
            this.wait(this.timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        t.interrupt();
        if (this.socket != null) {
            return this.socket;
        }
        if (this.ioe != null) {
            throw this.ioe;
        }
        if (this.exc != null) {
            throw new IOException(this.exc.toString());
        }
        throw new IOException("time out on connect");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.socket = new Socket(this.address, this.port);
        }
        catch (IOException ioexc) {
            this.ioe = ioexc;
        }
        catch (Exception any) {
            this.exc = any;
        }
        ConnectTimer connectTimer = this;
        synchronized (connectTimer) {
            this.notifyAll();
        }
    }

    public static Socket connect(InetAddress hostAddress, int hostPort, int timeoutMillis) throws IOException {
        ConnectTimer timer = new ConnectTimer(hostAddress, hostPort, timeoutMillis);
        return timer.open();
    }

    public static Socket connect(String hostName, int hostPort, int timeoutMillis) throws IOException {
        return ConnectTimer.connect(InetAddress.getByName(hostName), hostPort, timeoutMillis);
    }
}

