/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import java.io.IOException;

public class BrowserControl {
    private static final String WIN_ID = "Windows";
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    private static final String UNIX_PATH = "netscape";
    private static final String UNIX_FLAG = "-remote openURL";

    public static void displayURL(String url) {
        block6: {
            boolean windows = BrowserControl.isWindowsPlatform();
            String cmd = null;
            try {
                if (windows) {
                    cmd = "rundll32 url.dll,FileProtocolHandler " + url;
                    Process p = Runtime.getRuntime().exec(cmd);
                    break block6;
                }
                cmd = "netscape -remote openURL(" + url + ")";
                Process p = Runtime.getRuntime().exec(cmd);
                try {
                    int exitCode = p.waitFor();
                    if (exitCode != 0) {
                        cmd = "netscape " + url;
                        p = Runtime.getRuntime().exec(cmd);
                    }
                }
                catch (InterruptedException x) {
                    System.err.println("Error bringing up browser, cmd='" + cmd + "'");
                    System.err.println("Caught: " + x);
                }
            }
            catch (IOException x) {
                System.err.println("Could not invoke browser, command=" + cmd);
                System.err.println("Caught: " + x);
            }
        }
    }

    public static boolean isWindowsPlatform() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith(WIN_ID);
    }

    public static String getURLFromPath(String docPath) {
        if (!BrowserControl.isWindowsPlatform()) {
            return "file:\\\\" + docPath;
        }
        String noColonDocPath = docPath.replace(':', '|');
        return "file:///" + noColonDocPath.replace('\\', '/');
    }

    public static String getPathAddingDirectory(String addedDirectory) {
        String userDirectory = System.getProperty("user.dir");
        String fileSeparator = System.getProperty("file.separator");
        return String.valueOf(userDirectory) + fileSeparator + addedDirectory + fileSeparator;
    }

    public static String getDocumentPathAsURL(String docDirectory) {
        return BrowserControl.getURLFromPath(BrowserControl.getPathAddingDirectory(docDirectory));
    }

    private BrowserControl() {
    }

    public static void main(String[] args) {
        BrowserControl.displayURL("http://www.javaworld.com");
    }
}

