/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class Cache
extends LinkedHashMap
implements Serializable {
    static final long serialVersionUID = 3693500215986308797L;
    private boolean accessOrdering = false;
    private boolean autoSqueeze = false;
    private boolean caching = true;
    private int cacheLife = -1;
    private int maxCacheSize = 1000;
    private String name;
    private boolean verbose = false;

    public Cache() {
        this("", 1000, true);
    }

    public Cache(String aName, int maxCacheSize, boolean accessOrdering) {
        super(16, 0.75f, accessOrdering);
        this.setName(aName);
        this.setMaxCacheSize(maxCacheSize);
        this.accessOrdering = accessOrdering;
    }

    public Cache(int cacheLife, boolean autoSqueeze) {
        this("", cacheLife, 1000, false, autoSqueeze);
    }

    public Cache(String aName, int cacheLife, int maxCacheSize, boolean accessOrdering, boolean autoSqueeze) {
        super(16, 0.75f, accessOrdering);
        this.setName(aName);
        this.setCacheLife(cacheLife);
        this.setMaxCacheSize(maxCacheSize);
        this.accessOrdering = accessOrdering;
        this.setAutoSqueeze(autoSqueeze);
    }

    public static Cache getCacheFromFile(String fileName, boolean autoUpdate) throws ClassNotFoundException, IOException {
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(fileName));
        Object obj = ois.readObject();
        ois.close();
        Cache cache = (Cache)obj;
        cache.squeeze();
        if (autoUpdate) {
            cache.save(fileName);
        }
        return cache;
    }

    public int getCacheLife() {
        return this.cacheLife;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAccessOrdering() {
        return this.accessOrdering;
    }

    public boolean isAutoSqueeze() {
        return this.autoSqueeze;
    }

    public boolean isCaching() {
        return this.caching;
    }

    public boolean isTimeBased() {
        return this.cacheLife >= 0;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setAccessOrdering(boolean aBoolean) {
        this.accessOrdering = aBoolean;
    }

    public void setAutoSqueeze(boolean aBoolean) {
        this.autoSqueeze = aBoolean;
    }

    public void setCaching(boolean aBoolean) {
        this.caching = aBoolean;
    }

    public void setCacheLife(int anInt) {
        this.cacheLife = anInt;
    }

    public void setMaxCacheSize(int anInt) {
        if (anInt >= 0) {
            this.maxCacheSize = anInt;
            this.squeeze();
        } else {
            System.err.println("Cache '" + this.getName() + "'.setMaxCacheSize() -" + " cannot be set to a negative number.");
        }
    }

    public void setName(String aString) {
        this.name = aString;
    }

    public void setVerbose(boolean aBoolean) {
        this.verbose = aBoolean;
    }

    public synchronized boolean containsKey(Object key) {
        if (this.isTimeBased()) {
            this.squeeze();
        }
        return super.containsKey(key);
    }

    public synchronized boolean containsValue(Object obj) {
        if (this.isTimeBased()) {
            this.squeeze();
        }
        return super.containsValue(new CachedItem(obj));
    }

    public synchronized Object get(Object key) {
        if (this.caching) {
            CachedItem item;
            if (this.autoSqueeze) {
                this.squeeze();
            }
            if ((item = (CachedItem)super.get(key)) != null && this.isAccessOrdering()) {
                item.setCachedTimestamp(Calendar.getInstance());
            }
            if (item != null && !this.autoSqueeze && this.isTimeBased()) {
                Calendar cutoff = Calendar.getInstance();
                cutoff.add(13, -this.cacheLife);
                if (item.hasExpired(cutoff)) {
                    this.remove(key);
                    item = null;
                }
            }
            if (item != null) {
                if (this.verbose) {
                    System.out.println("Cache '" + this.getName() + "'.get() - key: " + key + ", value: " + item.getValue());
                }
                return item.getValue();
            }
            if (this.verbose) {
                System.out.println("Cache '" + this.getName() + "'.get() - key: " + key + " - item not found.");
            }
            return null;
        }
        if (this.verbose) {
            System.out.println("Cache '" + this.getName() + "'.get() - key: " + key + " - Caching turned off.");
        }
        return null;
    }

    public synchronized Object put(Object key, Object value) {
        if (this.caching) {
            if (this.verbose) {
                System.out.println("Cache '" + this.getName() + "'.put() - key: " + key + ", value: " + value);
            }
            Object result = value != null && value instanceof CachedItem ? super.put(key, value) : super.put(key, new CachedItem(value));
            if (this.autoSqueeze) {
                this.squeeze();
            }
            return result;
        }
        if (this.verbose) {
            System.out.println("Cache '" + this.getName() + "'.put() - key: " + key + ", value: " + value + " - Caching turned off.");
        }
        return null;
    }

    public synchronized void putAll(Map m) throws NullPointerException {
        if (this.caching) {
            Iterator entryIter = m.entrySet().iterator();
            while (entryIter.hasNext()) {
                Map.Entry entry = entryIter.next();
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public synchronized Object remove(Object key) {
        CachedItem removedItem = (CachedItem)super.remove(key);
        if (removedItem != null) {
            if (this.verbose) {
                System.out.println("Cache '" + this.getName() + "'.remove() - key: " + key + ", value: " + removedItem.getValue());
            }
            return removedItem.getValue();
        }
        if (this.verbose) {
            System.out.println("Cache '" + this.getName() + "'.remove() - key: " + key + ", item not found.");
        }
        return null;
    }

    public String toString() {
        return "Cache< Name: " + this.getName() + ", MaxCacheSize: " + this.getMaxCacheSize() + ", CacheLife: " + this.getCacheLife() + ", AccessOrdering: " + this.isAccessOrdering() + ", AutoSqueeze: " + this.isAutoSqueeze() + ", Caching: " + this.isCaching() + ", Verbose: " + this.isVerbose() + ", Content:\n" + super.toString() + " >\n";
    }

    public Collection values() {
        Iterator valueIter = super.values().iterator();
        ArrayList<Object> valueList = new ArrayList<Object>();
        while (valueIter.hasNext()) {
            valueList.add(((CachedItem)valueIter.next()).getValue());
        }
        return Collections.unmodifiableCollection(valueList);
    }

    protected boolean removeEldestEntry(Map.Entry eldest) {
        if (this.autoSqueeze) {
            return false;
        }
        return this.size() > this.getMaxCacheSize();
    }

    public synchronized boolean contains(Object anObject) {
        return this.containsKey(anObject);
    }

    public Collection getExpiredEntries() {
        Calendar cutoff = Calendar.getInstance();
        Iterator entryIter = super.entrySet().iterator();
        ArrayList entryList = new ArrayList();
        if (this.isTimeBased()) {
            cutoff.add(13, -this.getCacheLife());
            while (entryIter.hasNext()) {
                Map.Entry entry = entryIter.next();
                if (!((CachedItem)entry.getValue()).hasExpired(cutoff)) continue;
                entryList.add(entry);
            }
        }
        return Collections.unmodifiableCollection(entryList);
    }

    public Collection getExpiredValues() {
        Calendar cutoff = Calendar.getInstance();
        Iterator valueIter = super.values().iterator();
        ArrayList<Object> valueList = new ArrayList<Object>();
        if (this.isTimeBased()) {
            cutoff.add(13, -this.getCacheLife());
            while (valueIter.hasNext()) {
                CachedItem item = (CachedItem)valueIter.next();
                if (!item.hasExpired(cutoff)) continue;
                valueList.add(item.getValue());
            }
        }
        return Collections.unmodifiableCollection(valueList);
    }

    public synchronized void put(Object anObject) {
        this.put(anObject, (Object)null);
    }

    public synchronized void save(String fileName) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(fileName));
        this.squeeze();
        oos.writeObject(this);
        oos.close();
    }

    public synchronized void squeeze() {
        Map.Entry[] entries = super.entrySet().toArray(new Map.Entry[0]);
        int index = 0;
        if (this.verbose) {
            System.out.println("Cache '" + this.getName() + "' Squeezing Cache...");
        }
        if (this.isTimeBased()) {
            Calendar cutoff = Calendar.getInstance();
            cutoff.add(13, -this.getCacheLife());
            while (index < entries.length && ((CachedItem)entries[index].getValue()).hasExpired(cutoff)) {
                super.entrySet().remove(entries[index++]);
            }
        }
        while (super.entrySet().size() - this.getMaxCacheSize() > 0) {
            super.entrySet().remove(entries[index++]);
        }
    }

    public static class CachedItem
    implements Serializable {
        static final long serialVersionUID = -2748430846386219297L;
        private Calendar cachedTimestamp;
        private Object value;

        public CachedItem(Object anObject) {
            this(anObject, Calendar.getInstance());
        }

        public CachedItem(Object anObject, Calendar timestamp) {
            this.setValue(anObject);
            this.setCachedTimestamp(timestamp);
        }

        public Calendar getCachedTimestamp() {
            return this.cachedTimestamp;
        }

        public Object getValue() {
            return this.value;
        }

        public void setCachedTimestamp(Calendar aCalendar) {
            this.cachedTimestamp = aCalendar;
        }

        public void setValue(Object anObject) {
            this.value = anObject;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CachedItem) {
                if (this.getValue() != null) {
                    return this.getValue().equals(((CachedItem)obj).getValue());
                }
                return ((CachedItem)obj).getValue() == null;
            }
            return false;
        }

        public String toString() {
            return "CachedItem[Value: " + this.getValue() + ", Timestamp: " + this.getCachedTimestamp().getTime() + " ]\n";
        }

        public boolean hasExpired(Calendar cutoff) {
            return this.cachedTimestamp.before(cutoff);
        }
    }
}

