/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import ca.nanometrics.util.Log;
import java.io.IOException;
import java.io.InputStream;

public class DataBuffer {
    private static final int BUFFER_SIZE_IF_NO_CONTENT_LENGTH = 1024;
    private byte[] m_buffer;
    private int m_validLength;

    public DataBuffer(byte[] bytes, int length) {
        this.setBuffer(bytes);
        this.setValidLength(length);
    }

    public DataBuffer(InputStream in, int contentLength) throws IOException {
        if (Log.isDebug()) {
            Log.debug("DataBuffer", 1, "Reading data block " + contentLength + " bytes...");
        }
        long start = System.currentTimeMillis();
        if (contentLength > 0) {
            this.readWithContentLength(in, contentLength);
        } else {
            this.readWithNoContentLength(in);
        }
        long end = System.currentTimeMillis();
        int total = (int)(end - start);
        if (Log.isDebug()) {
            Log.debug("DataBuffer", 2, "Read data block: " + this.m_validLength + " bytes in " + total + "ms " + (total > 0 ? "(" + (long)this.m_validLength / (end - start) + "kB/s)" : ""));
        }
        in.close();
    }

    private void readWithNoContentLength(InputStream in) throws IOException {
        this.m_buffer = new byte[1024];
        int totalRead = 0;
        int bytesRead = 0;
        while ((bytesRead = in.read(this.m_buffer, totalRead, this.m_buffer.length - totalRead)) != -1) {
            if ((totalRead += bytesRead) != this.m_buffer.length) continue;
            byte[] newBuffer = new byte[this.m_buffer.length + 1024];
            System.arraycopy(this.m_buffer, 0, newBuffer, 0, this.m_buffer.length);
            this.m_buffer = newBuffer;
        }
        this.setValidLength(totalRead);
    }

    private void readWithContentLength(InputStream in, int contentLength) throws IOException {
        this.setBuffer(new byte[contentLength]);
        int bytesRead = 0;
        while (bytesRead < contentLength) {
            int rc = in.read(this.m_buffer, bytesRead, contentLength - bytesRead);
            if (rc < 0) {
                throw new IOException("End of stream reached:  Read " + bytesRead + " of " + contentLength + " bytes");
            }
            bytesRead += rc;
        }
        this.setValidLength(contentLength);
    }

    public byte[] getBuffer() {
        return this.m_buffer;
    }

    public int getLength() {
        return this.m_validLength;
    }

    private void setBuffer(byte[] buffer) {
        this.m_buffer = buffer;
    }

    private void setValidLength(int valid_length) {
        this.m_validLength = valid_length;
    }
}

