/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class FileHelper {
    public static boolean deleteFiles(File dir, String wildcard) throws IOException {
        if (dir.isDirectory()) {
            String[] children;
            if (wildcard.equals("*")) {
                children = dir.list();
            } else if (wildcard.endsWith("*")) {
                final String begin = wildcard.substring(0, wildcard.indexOf(42));
                children = dir.list(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.startsWith(begin);
                    }
                });
            } else {
                throw new IOException("Invalid wildcard used: " + wildcard);
            }
            int i = 0;
            while (i < children.length) {
                File file = new File(dir, children[i]);
                boolean success = FileHelper.deleteFile(file);
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static boolean deleteFile(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                File file = new File(dir, children[i]);
                boolean success = FileHelper.deleteFile(file);
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    public static boolean isLinux() {
        String os = System.getProperty("os.name").toLowerCase();
        return System.getProperty("os.name").toLowerCase().startsWith("linux");
    }

    public static long getFreeSpace(String path) throws Exception {
        if (FileHelper.isWindows()) {
            return FileHelper.getFreeSpaceOnWindows(path);
        }
        if (FileHelper.isLinux()) {
            return FileHelper.getFreeSpaceOnLinux(path);
        }
        throw new UnsupportedOperationException("The method getFreeSpace(String path) has not been implemented for this operating system.");
    }

    private static long getFreeSpaceOnWindows(String path) throws Exception {
        long bytesFree = -1L;
        File script = new File(System.getProperty("java.io.tmpdir"), "script.bat");
        PrintWriter writer = new PrintWriter(new FileWriter(script, false));
        writer.println("dir \"" + path + "\"");
        writer.close();
        String outputText = FileHelper.execCommandAndReadOutput(script.getAbsolutePath());
        StringTokenizer tokenizer = new StringTokenizer(outputText, "\n");
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken().trim();
            if (!line.endsWith("bytes free")) continue;
            tokenizer = new StringTokenizer(line, " ");
            tokenizer.nextToken();
            tokenizer.nextToken();
            bytesFree = Long.parseLong(tokenizer.nextToken().replaceAll(",", ""));
            return bytesFree;
        }
        return bytesFree;
    }

    private static String execCommandAndReadOutput(String command) throws IOException {
        int c;
        Process p = Runtime.getRuntime().exec(command);
        BufferedInputStream reader = new BufferedInputStream(p.getInputStream());
        StringBuffer buffer = new StringBuffer();
        while ((c = ((InputStream)reader).read()) != -1) {
            buffer.append((char)c);
        }
        String outputText = buffer.toString();
        ((InputStream)reader).close();
        return outputText;
    }

    private static long getFreeSpaceOnLinux(String path) throws Exception {
        long bytesFree = -1L;
        try {
            String outputText = FileHelper.execCommandAndReadOutput("df " + path);
            StringTokenizer tokenizer = new StringTokenizer(outputText, "\n");
            tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                String line2 = tokenizer.nextToken();
                StringTokenizer tokenizer2 = new StringTokenizer(line2, " ");
                if (tokenizer2.countTokens() >= 4) {
                    tokenizer2.nextToken();
                    tokenizer2.nextToken();
                    tokenizer2.nextToken();
                    bytesFree = Long.parseLong(tokenizer2.nextToken());
                    return bytesFree * 1024L;
                }
                return bytesFree;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1L;
    }
}

