/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import ca.nanometrics.util.Format;
import ca.nanometrics.util.PrintLog;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class FileLog
extends PrintLog {
    private PrintWriter log = null;
    private String logPath = null;
    private String logFile = null;
    private boolean mirrorToScreen = true;

    protected FileLog() {
    }

    public FileLog(String pathname, String filename) throws IOException {
        this();
        this.init(pathname, filename);
    }

    public FileLog(String filename) throws IOException {
        this();
        this.init(".", filename);
    }

    protected void init(String pathname, String filename) throws IOException {
        this.close();
        this.logPath = pathname;
        this.logFile = filename;
        this.log = this.open(this.logPath, this.logFile);
    }

    public void close() {
        if (this.log != null) {
            this.log.close();
        }
        this.log = null;
    }

    public void finalize() {
        this.close();
    }

    private PrintWriter open(String pathname, String filename) throws IOException {
        File path = new File(pathname);
        path.mkdirs();
        File file = new File(pathname, filename);
        PrintWriter writer = new PrintWriter(new FileWriter(file.getPath(), true));
        return writer;
    }

    public void setMirrorToScreen(boolean aBoolean) {
        this.mirrorToScreen = aBoolean;
    }

    public synchronized void reopen(String pathname, String filename, boolean isTest) throws IOException {
        PrintWriter writer = this.open(pathname, filename);
        if (isTest) {
            writer.close();
        } else {
            this.close();
            this.logPath = pathname;
            this.logFile = filename;
            this.log = writer;
        }
    }

    public synchronized void move() throws IOException {
        int maxExtension;
        this.close();
        File file = new File(this.logPath, this.logFile);
        Format fmt = new Format("_%03d");
        int extension = maxExtension = 1000;
        int ext = 1;
        while (ext < extension) {
            File dest = new File(this.logPath, String.valueOf(this.logFile) + fmt.form(ext));
            if (file.renameTo(dest)) {
                extension = ext;
            }
            ++ext;
        }
        this.log = this.open(this.logPath, this.logFile);
        if (extension < maxExtension) {
            this.report(this, 0, 2, "Moved log to " + this.logFile + fmt.form(extension));
        } else {
            this.report(this, 0, 3, "Could not move log");
        }
    }

    protected synchronized void report(String formattedMessage) {
        if (this.mirrorToScreen) {
            super.report(formattedMessage);
        }
        if (this.log != null) {
            this.log.println(formattedMessage);
            this.log.flush();
        }
    }
}

